﻿using System;
using Datex2_test;
using eu.datex2;

namespace pl.qumak
{

    class PushService
    {
        public void CallWebService()
        {
            Client wsClient = new Client();
            String response = wsClient.PushRequest(CreateD2());
        }

        private MessageContainer CreateD2()
        {
            MessageContainer messageContainer = new MessageContainer();

            ExchangeInformation exchange = new ExchangeInformation();
            exchange.modelBaseVersion = "3";
            InternationalIdentifier internationalIdentifier = new InternationalIdentifier
            {
                country = "PL",
                //Należy zmienić na nazwę firmy
                nationalIdentifier = "Nazwa Firmy"
            };
            Agent agent = new Agent();
            agent.internationalIdentifier = internationalIdentifier;
            ExchangeContext exchangeContext = new ExchangeContext();
            exchangeContext.supplierOrCisRequester = agent;
            exchangeContext.exchangeSpecificationVersion = "Exchange2020";
            _ProtocolTypeEnum protocolTypeEnum = new _ProtocolTypeEnum{ Value = ProtocolTypeEnum.snapshotPull };
            exchangeContext.codedExchangeProtocol = protocolTypeEnum;
            exchange.exchangeContext = exchangeContext;

            DynamicInformation dynamicInformation = new DynamicInformation
            {
                exchangeStatus = new _ExchangeStatusEnum { Value = ExchangeStatusEnum.undefined },
                messageGenerationTimestamp = DateTimeOffset.Now.LocalDateTime
            };
            exchange.dynamicInformation = dynamicInformation;
            messageContainer.exchangeInformation = exchange;


            HeaderInformation headerInformation =
                new HeaderInformation
                {
                    informationStatus = new _InformationStatusEnum{ Value = InformationStatusEnum.real }
                };

            SituationPublication situationPublication =
                new SituationPublication
                {
                    publicationTime = DateTimeOffset.Now.LocalDateTime,
                    publicationCreator = internationalIdentifier,
                    lang = "pl",
                    modelBaseVersion = "3"
                };

            SituationRecord situationRecord = CreateSituationRecord();
            situationRecord.id = "sr1245";
            situationRecord.version = "1";
            situationRecord.situationRecordCreationTime = DateTimeOffset.Now.LocalDateTime;
            situationRecord.situationRecordVersionTime = DateTimeOffset.Now.LocalDateTime;
            situationRecord.probabilityOfOccurrence = new _ProbabilityOfOccurrenceEnum { Value = ProbabilityOfOccurrenceEnum.certain };

            Validity validity = new Validity { validityStatus = new _ValidityStatusEnum { Value = ValidityStatusEnum.active } };
            OverallPeriod overallPeriod = new OverallPeriod { overallStartTime = DateTimeOffset.Now.LocalDateTime };
            validity.validityTimeSpecification = overallPeriod;
            situationRecord.validity = validity;

            Comment generalPublicComment = new Comment { commentType = new _CommentTypeEnum { Value = CommentTypeEnum.description} };
            StringHelper stringHelper = new StringHelper("PL");
            MultilingualString comment = stringHelper.createFrom(
                "Lokalizacja za pomocą współrzędnych. Punkt na A2 bramki przed Pruszkowem w stronę Warszawy.");
            generalPublicComment.comment = comment;
            Comment[] tempComment = new Comment[1];
            tempComment[0] = generalPublicComment;
            situationRecord.generalPublicComment = tempComment;

            PointByCoordinates pointByCoordinates = new PointByCoordinates();
            PointCoordinates coordinates = new PointCoordinates();
            float longitude = (float)20.729871;
            float latitude = (float)52.163258;
            coordinates.longitude = longitude;
            coordinates.latitude = latitude;
            pointByCoordinates.pointCoordinates = coordinates;
            PointLocation pointLocation = new PointLocation();
            pointLocation.pointByCoordinates = pointByCoordinates;
            situationRecord.locationReference = pointLocation;

            Situation situation = new Situation { headerInformation = headerInformation };
            situation.id = "s123";
            situation.situationVersionTime = DateTimeOffset.Now.LocalDateTime;
            SituationRecord[] situationRecords = new SituationRecord[1];
            situationRecords[0] = situationRecord;
            situation.situationRecord = situationRecords;
            situation.headerInformation = headerInformation;
            Situation[] situations = new Situation[1];
            situations[0] = situation;
            situationPublication.situation = situations;
            situationPublication.lang = "PL";

            PayloadPublication[] payloadPublications = new PayloadPublication[1];
            payloadPublications[0] = situationPublication;

            messageContainer.exchangeInformation = exchange;
            messageContainer.payload = payloadPublications;
            return messageContainer;
        }

        private static SituationRecord CreateSituationRecord()
        {
            WeatherRelatedRoadConditions weatherRelatedRoadConditions = new WeatherRelatedRoadConditions
            {
                weatherRelatedRoadConditionType = new[] { new _WeatherRelatedRoadConditionTypeEnum { Value = WeatherRelatedRoadConditionTypeEnum.blackIce } },
                trafficConstrictionType = new _TrafficConstrictionTypeEnum { Value = TrafficConstrictionTypeEnum.roadBlocked}
            };
            return weatherRelatedRoadConditions;
        }


    }
}
