/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2;

import eu.datex2.schema._2_0rc2._2_0.Accident;
import eu.datex2.schema._2_0rc2._2_0.D2LogicalModel;
import eu.datex2.schema._2_0rc2._2_0.Linear;
import eu.datex2.schema._2_0rc2._2_0.LinearExtensionType;
import eu.datex2.schema._2_0rc2._2_0.ObjectFactory;
import eu.datex2.schema._2_0rc2._2_0.OpenlrExtendedLinear;
import eu.datex2.schema._2_0rc2._2_0.OpenlrExtendedPoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLineLocationReference;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointLocationReference;
import eu.datex2.schema._2_0rc2._2_0.Point;
import eu.datex2.schema._2_0rc2._2_0.PointExtensionType;
import eu.datex2.schema._2_0rc2._2_0.Situation;
import eu.datex2.schema._2_0rc2._2_0.SituationPublication;
import javax.xml.bind.JAXBElement;
import openlr.LocationType;
import openlr.datex2.OpenLRDatex2Exception;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Datex2Location {
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private final OpenlrPointLocationReference pointData;
    private final OpenlrLineLocationReference lineData;
    private final LocationType locType;

    public Datex2Location(OpenlrPointLocationReference p) {
        this.pointData = p;
        this.lineData = null;
        this.locType = this.resolveLocationType(p);
    }

    private LocationType resolveLocationType(OpenlrPointLocationReference p) {
        LocationType lType = LocationType.UNKNOWN;
        if (p.getOpenlrGeoCoordinate() != null) {
            lType = LocationType.GEO_COORDINATES;
        } else if (p.getOpenlrPointAlongLine() != null) {
            lType = LocationType.POINT_ALONG_LINE;
        } else if (p.getOpenlrPoiWithAccessPoint() != null) {
            lType = LocationType.POI_WITH_ACCESS_POINT;
        }
        return lType;
    }

    public Datex2Location(OpenlrLineLocationReference l) {
        this.pointData = null;
        this.lineData = l;
        this.locType = LocationType.LINE_LOCATION;
    }

    Datex2Location(Object o) throws OpenLRDatex2Exception {
        LocationType l = null;
        if (o instanceof OpenlrLineLocationReference) {
            this.pointData = null;
            this.lineData = (OpenlrLineLocationReference)o;
            l = LocationType.LINE_LOCATION;
        } else if (o instanceof OpenlrPointLocationReference) {
            this.pointData = (OpenlrPointLocationReference)o;
            this.lineData = null;
            l = this.resolveLocationType(this.pointData);
        } else {
            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
        }
        if (l == LocationType.UNKNOWN) {
            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
        }
        this.locType = l;
    }

    public final LocationType getLocationType() {
        return this.locType;
    }

    public final boolean isPointLocation() {
        return this.pointData != null;
    }

    public final boolean isLineLocation() {
        return this.lineData != null;
    }

    public final OpenlrLineLocationReference getLineLocation() {
        return this.lineData;
    }

    public final OpenlrPointLocationReference getPointLocation() {
        return this.pointData;
    }

    public final JAXBElement<D2LogicalModel> getXMLData() {
        D2LogicalModel d2 = FACTORY.createD2LogicalModel();
        SituationPublication payload = FACTORY.createSituationPublication();
        d2.setPayloadPublication(payload);
        Situation s = FACTORY.createSituation();
        payload.getSituation().add(s);
        Accident record = FACTORY.createAccident();
        s.getSituationRecord().add(record);
        if (this.isLineLocation()) {
            Linear locations = FACTORY.createLinear();
            LinearExtensionType ext = FACTORY.createLinearExtensionType();
            OpenlrExtendedLinear openlrLinear = FACTORY.createOpenlrExtendedLinear();
            openlrLinear.setOpenlrLineLocationReference(this.lineData);
            ext.setOpenlrExtendedLinear(openlrLinear);
            locations.setLinearExtension(ext);
            record.setGroupOfLocations(locations);
        } else {
            Point locations = FACTORY.createPoint();
            PointExtensionType ext = FACTORY.createPointExtensionType();
            OpenlrExtendedPoint openlrPoint = FACTORY.createOpenlrExtendedPoint();
            openlrPoint.setOpenlrPointLocationReference(this.pointData);
            ext.setOpenlrExtendedPoint(openlrPoint);
            locations.setPointExtension(ext);
            record.setGroupOfLocations(locations);
        }
        return FACTORY.createD2LogicalModel(d2);
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.lineData).append((Object)this.pointData);
        return builder.toHashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Datex2Location)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Datex2Location other = (Datex2Location)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.locType, (Object)other.locType).append((Object)this.lineData, (Object)other.lineData).append((Object)this.pointData, (Object)other.pointData);
        return builder.isEquals();
    }
}

