/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2;

import eu.datex2.schema._2_0rc2._2_0.OpenlrGeoCoordinate;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPoiWithAccessPoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointAlongLine;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointLocationReference;
import openlr.LocationReference;
import openlr.PhysicalDecoder;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.datex2.Datex2Location;
import openlr.datex2.OpenLRDatex2Exception;
import openlr.datex2.decoder.GeoCoordDecoder;
import openlr.datex2.decoder.LineDecoder;
import openlr.datex2.decoder.PoiAccessDecoder;
import openlr.datex2.decoder.PointAlongDecoder;
import openlr.rawLocRef.RawLocationReference;

public class OpenLRDatex2Decoder
implements PhysicalDecoder {
    public final RawLocationReference decodeData(LocationReference lr) throws PhysicalFormatException {
        Object data = lr.getLocationReferenceData();
        if (!(data instanceof Datex2Location)) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        RawLocationReference rawLocRef = null;
        Datex2Location xmlData = (Datex2Location)data;
        if (xmlData.isLineLocation()) {
            LineDecoder decoder = new LineDecoder();
            rawLocRef = decoder.decodeData(lr.getID(), xmlData.getLineLocation());
        } else if (xmlData.isPointLocation()) {
            OpenlrPointLocationReference pointLoc = xmlData.getPointLocation();
            OpenlrGeoCoordinate gCoord = pointLoc.getOpenlrGeoCoordinate();
            OpenlrPointAlongLine pal = pointLoc.getOpenlrPointAlongLine();
            OpenlrPoiWithAccessPoint palwap = pointLoc.getOpenlrPoiWithAccessPoint();
            if (gCoord == null && pal == null && palwap == null) {
                throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "no point location found");
            }
            if (gCoord != null) {
                GeoCoordDecoder decoder = new GeoCoordDecoder();
                rawLocRef = decoder.decodeData(lr.getID(), gCoord);
            } else if (pal != null) {
                PointAlongDecoder decoder = new PointAlongDecoder();
                rawLocRef = decoder.decodeData(lr.getID(), pal);
            } else if (palwap != null) {
                PoiAccessDecoder decoder = new PoiAccessDecoder();
                rawLocRef = decoder.decodeData(lr.getID(), palwap);
            }
        }
        return rawLocRef;
    }

    public final Class<?> getDataClass() {
        return Datex2Location.class;
    }

    public final String getDataFormatIdentifier() {
        return "datex2";
    }
}

