/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2;

import openlr.LocationReference;
import openlr.LocationType;
import openlr.PhysicalEncoder;
import openlr.datex2.Datex2Location;
import openlr.datex2.Datex2ReturnCode;
import openlr.datex2.encoder.GeoCoordEncoder;
import openlr.datex2.encoder.LineEncoder;
import openlr.datex2.encoder.PoiAccessEncoder;
import openlr.datex2.encoder.PointAlongEncoder;
import openlr.datex2.impl.LocationReferenceImpl;
import openlr.rawLocRef.RawLocationReference;

public class OpenLRDatex2Encoder
implements PhysicalEncoder {
    private static final int[] VERSIONS = new int[]{11};

    private boolean checkVersion(int ver) {
        for (int v : VERSIONS) {
            if (v != ver) continue;
            return true;
        }
        return false;
    }

    public final Class<?> getDataClass() {
        return Datex2Location.class;
    }

    public final String getDataFormatIdentifier() {
        return "datex2";
    }

    public final int[] getSupportedVersions() {
        return (int[])VERSIONS.clone();
    }

    public final LocationReference encodeData(RawLocationReference rawLocRef) {
        return this.encodeData(rawLocRef, VERSIONS[VERSIONS.length - 1]);
    }

    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        if (!this.checkVersion(version)) {
            return new LocationReferenceImpl(rawLocRef.getID(), Datex2ReturnCode.INVALID_VERSION, rawLocRef.getLocationType(), version);
        }
        LocationType lt = rawLocRef.getLocationType();
        LocationReference lr = null;
        switch (lt) {
            case GEO_COORDINATES: {
                GeoCoordEncoder geoEncoder = new GeoCoordEncoder();
                lr = geoEncoder.encodeData(rawLocRef, version);
                break;
            }
            case LINE_LOCATION: {
                LineEncoder lineEncoder = new LineEncoder();
                lr = lineEncoder.encodeData(rawLocRef, version);
                break;
            }
            case POI_WITH_ACCESS_POINT: {
                PoiAccessEncoder poiEncoder = new PoiAccessEncoder();
                lr = poiEncoder.encodeData(rawLocRef, version);
                break;
            }
            case POINT_ALONG_LINE: {
                PointAlongEncoder pointAlongEncoder = new PointAlongEncoder();
                lr = pointAlongEncoder.encodeData(rawLocRef, version);
                break;
            }
            default: {
                return new LocationReferenceImpl(rawLocRef.getID(), Datex2ReturnCode.UNKNOWN_LOCATION_TYPE, rawLocRef.getLocationType(), version);
            }
        }
        return lr;
    }
}

