/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2;

import eu.datex2.schema._2_0rc2._2_0.Accident;
import eu.datex2.schema._2_0rc2._2_0.D2LogicalModel;
import eu.datex2.schema._2_0rc2._2_0.GroupOfLocations;
import eu.datex2.schema._2_0rc2._2_0.Linear;
import eu.datex2.schema._2_0rc2._2_0.ObjectFactory;
import eu.datex2.schema._2_0rc2._2_0.OpenlrExtendedLinear;
import eu.datex2.schema._2_0rc2._2_0.OpenlrExtendedPoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLineLocationReference;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointLocationReference;
import eu.datex2.schema._2_0rc2._2_0.Point;
import eu.datex2.schema._2_0rc2._2_0.Situation;
import eu.datex2.schema._2_0rc2._2_0.SituationPublication;
import eu.datex2.schema._2_0rc2._2_0.SituationRecord;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import openlr.StatusCode;
import openlr.datex2.Datex2Location;
import openlr.datex2.OpenLRDatex2Exception;
import org.xml.sax.SAXException;

public class XmlReader {
    private static final Class<?> OBJECT_FACTORY = ObjectFactory.class;
    private static final Object SYNC_OBJECT = new Object();
    private final JAXBContext jc;

    public XmlReader() throws OpenLRDatex2Exception {
        try {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{OBJECT_FACTORY});
        }
        catch (JAXBException e) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.XML_ERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Datex2Location readDatex2Location(File file) throws JAXBException, SAXException, FileNotFoundException, OpenLRDatex2Exception {
        Datex2Location result = null;
        if (file != null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Unmarshaller unmarshaller = this.jc.createUnmarshaller();
                result = new Datex2Location(unmarshaller.unmarshal((Source)new StreamSource(new BufferedInputStream(new FileInputStream(file)))));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Datex2Location readDatex2Location(InputStream is) throws JAXBException, SAXException, OpenLRDatex2Exception {
        Datex2Location result = null;
        if (is != null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Unmarshaller unmarshaller = this.jc.createUnmarshaller();
                Object o = unmarshaller.unmarshal((Source)new StreamSource(new BufferedInputStream(is)));
                Object data = ((JAXBElement)o).getValue();
                if (!(data instanceof OpenlrLineLocationReference) && !(data instanceof OpenlrPointLocationReference)) {
                    if (data instanceof D2LogicalModel) {
                        D2LogicalModel model = (D2LogicalModel)data;
                        if (model.getPayloadPublication() == null || !(model.getPayloadPublication() instanceof SituationPublication)) {
                            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                        }
                        SituationPublication payload = (SituationPublication)model.getPayloadPublication();
                        if (payload.getSituation().isEmpty()) {
                            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                        }
                        Situation s = payload.getSituation().get(0);
                        if (s == null || s.getSituationRecord().isEmpty()) {
                            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                        }
                        SituationRecord record = s.getSituationRecord().get(0);
                        if (record == null || !(record instanceof Accident)) {
                            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                        }
                        Accident a = (Accident)record;
                        GroupOfLocations locations = a.getGroupOfLocations();
                        if (locations instanceof Linear) {
                            Linear linLoc = (Linear)locations;
                            if (linLoc.getLinearExtension() == null || linLoc.getLinearExtension().getOpenlrExtendedLinear() == null) {
                                throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                            }
                            OpenlrExtendedLinear linear = linLoc.getLinearExtension().getOpenlrExtendedLinear();
                            if (linear.getOpenlrLineLocationReference() == null) {
                                throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                            }
                            return new Datex2Location(linear.getOpenlrLineLocationReference());
                        }
                        if (locations instanceof Point) {
                            Point pointLoc = (Point)locations;
                            if (pointLoc.getPointExtension() == null || pointLoc.getPointExtension().getOpenlrExtendedPoint() == null) {
                                throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                            }
                            OpenlrExtendedPoint point = pointLoc.getPointExtension().getOpenlrExtendedPoint();
                            if (point.getOpenlrPointLocationReference() == null) {
                                throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                            }
                            return new Datex2Location(point.getOpenlrPointLocationReference());
                        }
                        throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                    }
                    throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR);
                }
                result = new Datex2Location(data);
            }
        }
        return result;
    }
}

