/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.decoder;

import eu.datex2.schema._2_0rc2._2_0.OpenlrBaseLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrFormOfWayEnum;
import eu.datex2.schema._2_0rc2._2_0.OpenlrFunctionalRoadClassEnum;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLineAttributes;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrOffsets;
import eu.datex2.schema._2_0rc2._2_0.OpenlrOrientationEnum;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPathAttributes;
import eu.datex2.schema._2_0rc2._2_0.OpenlrSideOfRoadEnum;
import eu.datex2.schema._2_0rc2._2_0.PointCoordinates;
import java.math.BigInteger;
import openlr.LocationReferencePoint;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.datex2.OpenLRDatex2Exception;
import openlr.datex2.impl.LocationReferencePointImpl;
import openlr.datex2.impl.OffsetsImpl;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.FormOfWay;
import openlr.map.FunctionalRoadClass;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.rawLocRef.RawLocationReference;

public abstract class AbstractDecoder {
    public abstract RawLocationReference decodeData(String var1, Object var2) throws PhysicalFormatException;

    protected final Offsets readOffsets(BigInteger offsetDistance) {
        int poff = 0;
        if (offsetDistance != null) {
            poff = offsetDistance.intValue();
        }
        return new OffsetsImpl(poff, 0);
    }

    protected final Orientation resolveOrientation(OpenlrOrientationEnum orientation2) {
        Orientation o = null;
        switch (orientation2) {
            case NO_ORIENTATION_OR_UNKNOWN: {
                o = Orientation.NO_ORIENTATION_OR_UNKNOWN;
                break;
            }
            case WITH_LINE_DIRECTION: {
                o = Orientation.WITH_LINE_DIRECTION;
                break;
            }
            case AGAINST_LINE_DIRECTION: {
                o = Orientation.AGAINST_LINE_DIRECTION;
                break;
            }
            case BOTH: {
                o = Orientation.BOTH;
                break;
            }
            default: {
                o = Orientation.getDefault();
            }
        }
        return o;
    }

    protected final SideOfRoad resolveSideOfRoad(OpenlrSideOfRoadEnum sideOfRoad2) {
        SideOfRoad s = null;
        switch (sideOfRoad2) {
            case ON_ROAD_OR_UNKNOWN: {
                s = SideOfRoad.ON_ROAD_OR_UNKNOWN;
                break;
            }
            case RIGHT: {
                s = SideOfRoad.RIGHT;
                break;
            }
            case LEFT: {
                s = SideOfRoad.LEFT;
                break;
            }
            case BOTH: {
                s = SideOfRoad.BOTH;
                break;
            }
            default: {
                s = SideOfRoad.getDefault();
            }
        }
        return s;
    }

    protected final GeoCoordinates createGeoCoord(PointCoordinates c) throws OpenLRDatex2Exception {
        if (c == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "no coordinates found");
        }
        GeoCoordinatesImpl gc = null;
        try {
            gc = new GeoCoordinatesImpl((double)c.getLongitude(), (double)c.getLatitude());
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDatex2Exception(OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "no coordinates found", e);
        }
        return gc;
    }

    protected final LocationReferencePoint createLastLRP(int seqNr, OpenlrBaseLocationReferencePoint lastLRP) throws OpenLRDatex2Exception {
        PointCoordinates coord = lastLRP.getOpenlrCoordinate();
        if (coord == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "invalid coordinates");
        }
        double lon = coord.getLongitude();
        double lat = coord.getLatitude();
        OpenlrLineAttributes lineAttr = lastLRP.getOpenlrLineAttributes();
        if (lineAttr == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "invalid line attributes");
        }
        double bearing = lineAttr.getOpenlrBearing();
        FunctionalRoadClass frc = this.mapFRC(lineAttr.getOpenlrFunctionalRoadClass());
        FormOfWay fow = this.mapFOW(lineAttr.getOpenlrFormOfWay());
        return new LocationReferencePointImpl(seqNr, frc, fow, lon, lat, bearing, 0, null, true);
    }

    private FormOfWay mapFOW(OpenlrFormOfWayEnum fow) {
        FormOfWay f = null;
        switch (fow) {
            case MOTORWAY: {
                f = FormOfWay.MOTORWAY;
                break;
            }
            case MULTIPLE_CARRIAGEWAY: {
                f = FormOfWay.MULTIPLE_CARRIAGEWAY;
                break;
            }
            case OTHER: {
                f = FormOfWay.OTHER;
                break;
            }
            case ROUNDABOUT: {
                f = FormOfWay.ROUNDABOUT;
                break;
            }
            case SINGLE_CARRIAGEWAY: {
                f = FormOfWay.SINGLE_CARRIAGEWAY;
                break;
            }
            case SLIP_ROAD: {
                f = FormOfWay.SLIPROAD;
                break;
            }
            case TRAFFIC_SQUARE: {
                f = FormOfWay.TRAFFIC_SQUARE;
                break;
            }
            case UNDEFINED: {
                f = FormOfWay.UNDEFINED;
                break;
            }
            default: {
                f = null;
            }
        }
        return f;
    }

    private FunctionalRoadClass mapFRC(OpenlrFunctionalRoadClassEnum frc) {
        FunctionalRoadClass f = null;
        switch (frc) {
            case FRC_0: {
                f = FunctionalRoadClass.FRC_0;
                break;
            }
            case FRC_1: {
                f = FunctionalRoadClass.FRC_1;
                break;
            }
            case FRC_2: {
                f = FunctionalRoadClass.FRC_2;
                break;
            }
            case FRC_3: {
                f = FunctionalRoadClass.FRC_3;
                break;
            }
            case FRC_4: {
                f = FunctionalRoadClass.FRC_4;
                break;
            }
            case FRC_5: {
                f = FunctionalRoadClass.FRC_5;
                break;
            }
            case FRC_6: {
                f = FunctionalRoadClass.FRC_6;
                break;
            }
            case FRC_7: {
                f = FunctionalRoadClass.FRC_7;
                break;
            }
            default: {
                f = null;
            }
        }
        return f;
    }

    protected final LocationReferencePoint createLRP(int seqNr, OpenlrLocationReferencePoint xmlLRP) throws OpenLRDatex2Exception {
        PointCoordinates coord = xmlLRP.getOpenlrCoordinate();
        if (coord == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "invalid coordinates");
        }
        double lon = coord.getLongitude();
        double lat = coord.getLatitude();
        OpenlrLineAttributes lineAttr = xmlLRP.getOpenlrLineAttributes();
        if (lineAttr == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "invalid line attributes");
        }
        double bearing = lineAttr.getOpenlrBearing();
        FunctionalRoadClass frc = this.mapFRC(lineAttr.getOpenlrFunctionalRoadClass());
        FormOfWay fow = this.mapFOW(lineAttr.getOpenlrFormOfWay());
        OpenlrPathAttributes pathAttr = xmlLRP.getOpenlrPathAttributes();
        if (pathAttr == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "invalid path attributes");
        }
        BigInteger xmlDNP = pathAttr.getOpenlrDistanceToNextLRPoint();
        if (xmlDNP == null) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "invalid dnp attribute");
        }
        int dnp = xmlDNP.intValue();
        FunctionalRoadClass lfrc = this.mapFRC(pathAttr.getOpenlrLowestFRCToNextLRPoint());
        return new LocationReferencePointImpl(seqNr, frc, fow, lon, lat, bearing, dnp, lfrc, false);
    }

    protected final Offsets readOffsets(OpenlrOffsets xmlOffsets) throws OpenLRDatex2Exception {
        int pOffset = 0;
        int nOffset = 0;
        if (xmlOffsets == null) {
            return new OffsetsImpl(pOffset, nOffset);
        }
        BigInteger poff = xmlOffsets.getOpenlrPositiveOffset();
        BigInteger noff = xmlOffsets.getOpenlrNegativeOffset();
        if (poff != null) {
            pOffset = poff.intValue();
        }
        if (noff != null) {
            nOffset = noff.intValue();
        }
        return new OffsetsImpl(pOffset, nOffset);
    }
}

