/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.decoder;

import eu.datex2.schema._2_0rc2._2_0.OpenlrLastLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLineLocationReference;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLocationReferencePoint;
import java.util.ArrayList;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.datex2.Datex2ReturnCode;
import openlr.datex2.OpenLRDatex2Exception;
import openlr.datex2.decoder.AbstractDecoder;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLineLocRef;
import openlr.rawLocRef.RawLocationReference;

public class LineDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof OpenlrLineLocationReference)) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        OpenlrLineLocationReference lineLoc = (OpenlrLineLocationReference)data;
        ArrayList<LocationReferencePoint> points = new ArrayList<LocationReferencePoint>();
        List<OpenlrLocationReferencePoint> locPoints = lineLoc.getOpenlrLocationReferencePoint();
        if (locPoints == null || locPoints.isEmpty()) {
            return new RawInvalidLocRef("", (StatusCode)Datex2ReturnCode.INVALID_NUMBER_OF_LRP, LocationType.LINE_LOCATION);
        }
        Offsets offsets = this.readOffsets(lineLoc.getOpenlrOffsets());
        int lrpCount = 1;
        for (OpenlrLocationReferencePoint xmlLRP : locPoints) {
            points.add(this.createLRP(lrpCount, xmlLRP));
            ++lrpCount;
        }
        OpenlrLastLocationReferencePoint lastLRP = lineLoc.getOpenlrLastLocationReferencePoint();
        if (lastLRP == null) {
            return new RawInvalidLocRef("", (StatusCode)Datex2ReturnCode.NO_LAST_LRP_FOUND, LocationType.LINE_LOCATION);
        }
        points.add(this.createLastLRP(lrpCount, lastLRP));
        RawLineLocRef rawLocRef = new RawLineLocRef(id, points, offsets);
        return rawLocRef;
    }
}

