/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.decoder;

import eu.datex2.schema._2_0rc2._2_0.OpenlrLastLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPoiWithAccessPoint;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.datex2.Datex2ReturnCode;
import openlr.datex2.OpenLRDatex2Exception;
import openlr.datex2.decoder.AbstractDecoder;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPoiAccessLocRef;

public class PoiAccessDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof OpenlrPoiWithAccessPoint)) {
            throw new OpenLRDatex2Exception((StatusCode)OpenLRDatex2Exception.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        OpenlrPoiWithAccessPoint palwap = (OpenlrPoiWithAccessPoint)data;
        OpenlrLocationReferencePoint startLRP = palwap.getOpenlrLocationReferencePoint();
        OpenlrLastLocationReferencePoint endLRP = palwap.getOpenlrLastLocationReferencePoint();
        if (startLRP == null || endLRP == null) {
            return new RawInvalidLocRef("", (StatusCode)Datex2ReturnCode.INVALID_NUMBER_OF_LRP, LocationType.LINE_LOCATION);
        }
        Offsets offsets = this.readOffsets(palwap.getOpenlrPositiveOffset());
        LocationReferencePoint lrp01 = this.createLRP(1, startLRP);
        LocationReferencePoint lrp02 = this.createLastLRP(2, endLRP);
        GeoCoordinates geoCoord = this.createGeoCoord(palwap.getOpenlrCoordinate());
        SideOfRoad sideOfRoad = this.resolveSideOfRoad(palwap.getOpenlrSideOfRoad());
        Orientation orientation = this.resolveOrientation(palwap.getOpenlrOrientation());
        RawPoiAccessLocRef rawLocRef = new RawPoiAccessLocRef(id, lrp01, lrp02, offsets, geoCoord, sideOfRoad, orientation);
        return rawLocRef;
    }
}

