/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.encoder;

import eu.datex2.schema._2_0rc2._2_0.ObjectFactory;
import eu.datex2.schema._2_0rc2._2_0.OpenlrFormOfWayEnum;
import eu.datex2.schema._2_0rc2._2_0.OpenlrFunctionalRoadClassEnum;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLastLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLineAttributes;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrOffsets;
import eu.datex2.schema._2_0rc2._2_0.OpenlrOrientationEnum;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPathAttributes;
import eu.datex2.schema._2_0rc2._2_0.OpenlrSideOfRoadEnum;
import eu.datex2.schema._2_0rc2._2_0.PointCoordinates;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.Offsets;
import openlr.datex2.OpenLRDatex2Constants;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.FormOfWay;
import openlr.map.FunctionalRoadClass;
import openlr.rawLocRef.RawLocationReference;

public abstract class AbstractEncoder {
    private static final int FULL_CIRCLE = 360;
    protected static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public abstract LocationReference encodeData(RawLocationReference var1, int var2);

    protected final OpenlrLastLocationReferencePoint createLastLRP(List<? extends LocationReferencePoint> locRef) {
        OpenlrLastLocationReferencePoint llrp = OBJECT_FACTORY.createOpenlrLastLocationReferencePoint();
        LocationReferencePoint l = locRef.get(locRef.size() - 1);
        PointCoordinates coord = this.createCoordinates(l);
        llrp.setOpenlrCoordinate(coord);
        OpenlrLineAttributes lineAttr = this.createLineAttr(l);
        llrp.setOpenlrLineAttributes(lineAttr);
        return llrp;
    }

    protected final List<OpenlrLocationReferencePoint> createLRPs(List<? extends LocationReferencePoint> locRef) {
        ArrayList<OpenlrLocationReferencePoint> points = new ArrayList<OpenlrLocationReferencePoint>();
        for (int i = 0; i < locRef.size() - 1; ++i) {
            LocationReferencePoint lrp = locRef.get(i);
            points.add(this.createLRP(lrp));
        }
        return points;
    }

    protected final OpenlrLocationReferencePoint createLRP(LocationReferencePoint lrp) {
        OpenlrLocationReferencePoint l = OBJECT_FACTORY.createOpenlrLocationReferencePoint();
        PointCoordinates coord = this.createCoordinates(lrp);
        l.setOpenlrCoordinate(coord);
        OpenlrLineAttributes lineAttr = this.createLineAttr(lrp);
        l.setOpenlrLineAttributes(lineAttr);
        OpenlrPathAttributes pathAttr = this.createPathAttr(lrp);
        l.setOpenlrPathAttributes(pathAttr);
        return l;
    }

    private OpenlrPathAttributes createPathAttr(LocationReferencePoint lrp) {
        OpenlrPathAttributes pathAttr = OBJECT_FACTORY.createOpenlrPathAttributes();
        pathAttr.setOpenlrDistanceToNextLRPoint(BigInteger.valueOf(lrp.getDistanceToNext()));
        pathAttr.setOpenlrLowestFRCToNextLRPoint(this.mapFRC(lrp.getLfrc()));
        return pathAttr;
    }

    private OpenlrLineAttributes createLineAttr(LocationReferencePoint lrp) {
        OpenlrLineAttributes lineAttr = OBJECT_FACTORY.createOpenlrLineAttributes();
        int bearing = (int)Math.round(lrp.getBearing());
        if (bearing == 360) {
            bearing = 0;
        }
        lineAttr.setOpenlrBearing(bearing);
        lineAttr.setOpenlrFormOfWay(this.mapFOW(lrp.getFOW()));
        lineAttr.setOpenlrFunctionalRoadClass(this.mapFRC(lrp.getFRC()));
        return lineAttr;
    }

    private OpenlrFunctionalRoadClassEnum mapFRC(FunctionalRoadClass frc) {
        OpenlrFunctionalRoadClassEnum frcType = null;
        switch (frc) {
            case FRC_0: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_0;
                break;
            }
            case FRC_1: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_1;
                break;
            }
            case FRC_2: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_2;
                break;
            }
            case FRC_3: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_3;
                break;
            }
            case FRC_4: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_4;
                break;
            }
            case FRC_5: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_5;
                break;
            }
            case FRC_6: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_6;
                break;
            }
            case FRC_7: {
                frcType = OpenlrFunctionalRoadClassEnum.FRC_7;
                break;
            }
            default: {
                frcType = null;
            }
        }
        return frcType;
    }

    private OpenlrFormOfWayEnum mapFOW(FormOfWay fow) {
        OpenlrFormOfWayEnum fowType = null;
        switch (fow) {
            case MOTORWAY: {
                fowType = OpenlrFormOfWayEnum.MOTORWAY;
                break;
            }
            case MULTIPLE_CARRIAGEWAY: {
                fowType = OpenlrFormOfWayEnum.MULTIPLE_CARRIAGEWAY;
                break;
            }
            case OTHER: {
                fowType = OpenlrFormOfWayEnum.OTHER;
                break;
            }
            case ROUNDABOUT: {
                fowType = OpenlrFormOfWayEnum.ROUNDABOUT;
                break;
            }
            case SINGLE_CARRIAGEWAY: {
                fowType = OpenlrFormOfWayEnum.SINGLE_CARRIAGEWAY;
                break;
            }
            case SLIPROAD: {
                fowType = OpenlrFormOfWayEnum.SLIP_ROAD;
                break;
            }
            case TRAFFIC_SQUARE: {
                fowType = OpenlrFormOfWayEnum.TRAFFIC_SQUARE;
                break;
            }
            case UNDEFINED: {
                fowType = OpenlrFormOfWayEnum.UNDEFINED;
                break;
            }
            default: {
                fowType = null;
            }
        }
        return fowType;
    }

    private PointCoordinates createCoordinates(LocationReferencePoint lrp) {
        PointCoordinates coord = OBJECT_FACTORY.createPointCoordinates();
        coord.setLatitude((float)lrp.getLatitudeDeg());
        coord.setLongitude((float)lrp.getLongitudeDeg());
        return coord;
    }

    protected final OpenlrOffsets createOffsets(Offsets od, boolean negIncluded) {
        OpenlrOffsets off = OBJECT_FACTORY.createOpenlrOffsets();
        BigInteger pdist = OpenLRDatex2Constants.NO_OFFSET;
        BigInteger ndist = OpenLRDatex2Constants.NO_OFFSET;
        if (od.hasPositiveOffset()) {
            pdist = BigInteger.valueOf(od.getPositiveOffset(0));
        }
        if (negIncluded && od.hasNegativeOffset()) {
            ndist = BigInteger.valueOf(od.getNegativeOffset(0));
        }
        off.setOpenlrNegativeOffset(ndist);
        off.setOpenlrPositiveOffset(pdist);
        return off;
    }

    protected final OpenlrOrientationEnum resolveOrientation(Orientation o) {
        OpenlrOrientationEnum ot = null;
        switch (o) {
            case NO_ORIENTATION_OR_UNKNOWN: {
                ot = OpenlrOrientationEnum.NO_ORIENTATION_OR_UNKNOWN;
                break;
            }
            case WITH_LINE_DIRECTION: {
                ot = OpenlrOrientationEnum.WITH_LINE_DIRECTION;
                break;
            }
            case AGAINST_LINE_DIRECTION: {
                ot = OpenlrOrientationEnum.AGAINST_LINE_DIRECTION;
                break;
            }
            case BOTH: {
                ot = OpenlrOrientationEnum.BOTH;
                break;
            }
            default: {
                ot = OpenlrOrientationEnum.NO_ORIENTATION_OR_UNKNOWN;
            }
        }
        return ot;
    }

    protected final OpenlrSideOfRoadEnum resolveSideOfRoad(SideOfRoad s) {
        OpenlrSideOfRoadEnum st = null;
        switch (s) {
            case ON_ROAD_OR_UNKNOWN: {
                st = OpenlrSideOfRoadEnum.ON_ROAD_OR_UNKNOWN;
                break;
            }
            case RIGHT: {
                st = OpenlrSideOfRoadEnum.RIGHT;
                break;
            }
            case LEFT: {
                st = OpenlrSideOfRoadEnum.LEFT;
                break;
            }
            case BOTH: {
                st = OpenlrSideOfRoadEnum.BOTH;
                break;
            }
            default: {
                st = OpenlrSideOfRoadEnum.ON_ROAD_OR_UNKNOWN;
            }
        }
        return st;
    }
}

