/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.encoder;

import eu.datex2.schema._2_0rc2._2_0.OpenlrLastLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLineLocationReference;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrOffsets;
import java.util.List;
import openlr.LocationReference;
import openlr.LocationType;
import openlr.Offsets;
import openlr.datex2.Datex2ReturnCode;
import openlr.datex2.encoder.AbstractEncoder;
import openlr.datex2.impl.LocationReferenceImpl;
import openlr.rawLocRef.RawLocationReference;

public class LineEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        List locRef = rawLocRef.getLocationReferencePoints();
        Offsets od = rawLocRef.getOffsets();
        if (locRef == null || od == null) {
            return new LocationReferenceImpl(rawLocRef.getID(), Datex2ReturnCode.DATA_ERROR, LocationType.LINE_LOCATION, version);
        }
        OpenlrLineLocationReference xmlLoc = OBJECT_FACTORY.createOpenlrLineLocationReference();
        OpenlrOffsets o = this.createOffsets(od, true);
        xmlLoc.setOpenlrOffsets(o);
        List<OpenlrLocationReferencePoint> lrps = this.createLRPs(locRef);
        xmlLoc.getOpenlrLocationReferencePoint().addAll(lrps);
        OpenlrLastLocationReferencePoint llrp = this.createLastLRP(locRef);
        xmlLoc.setOpenlrLastLocationReferencePoint(llrp);
        return new LocationReferenceImpl(rawLocRef.getID(), xmlLoc, version);
    }
}

