/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.encoder;

import eu.datex2.schema._2_0rc2._2_0.OpenlrLastLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrLocationReferencePoint;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointAlongLine;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointLocationReference;
import java.math.BigInteger;
import java.util.ArrayList;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.Offsets;
import openlr.datex2.OpenLRDatex2Constants;
import openlr.datex2.encoder.AbstractEncoder;
import openlr.datex2.impl.LocationReferenceImpl;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.rawLocRef.RawLocationReference;

public class PointAlongEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        LocationReferencePoint startLRP = (LocationReferencePoint)rawLocRef.getLocationReferencePoints().get(0);
        LocationReferencePoint endLRP = (LocationReferencePoint)rawLocRef.getLocationReferencePoints().get(1);
        Offsets od = rawLocRef.getOffsets();
        SideOfRoad s = rawLocRef.getSideOfRoad();
        Orientation o = rawLocRef.getOrientation();
        OpenlrPointLocationReference xmlData = OBJECT_FACTORY.createOpenlrPointLocationReference();
        OpenlrPointAlongLine xmlLoc = OBJECT_FACTORY.createOpenlrPointAlongLine();
        OpenlrLocationReferencePoint lrp1 = this.createLRP(startLRP);
        ArrayList<LocationReferencePoint> lrps = new ArrayList<LocationReferencePoint>();
        lrps.add(startLRP);
        lrps.add(endLRP);
        OpenlrLastLocationReferencePoint lrp2 = this.createLastLRP(lrps);
        BigInteger dist = OpenLRDatex2Constants.NO_OFFSET;
        if (od.hasPositiveOffset()) {
            dist = BigInteger.valueOf(od.getPositiveOffset(0));
        }
        xmlLoc.setOpenlrLocationReferencePoint(lrp1);
        xmlLoc.setOpenlrLastLocationReferencePoint(lrp2);
        xmlLoc.setOpenlrPositiveOffset(dist);
        xmlLoc.setOpenlrSideOfRoad(this.resolveSideOfRoad(s));
        xmlLoc.setOpenlrOrientation(this.resolveOrientation(o));
        xmlData.setOpenlrPointAlongLine(xmlLoc);
        LocationReferenceImpl locRefData = new LocationReferenceImpl(rawLocRef.getID(), xmlData, version);
        return locRefData;
    }
}

