/*
 * Decompiled with CFR 0.152.
 */
package openlr.datex2.impl;

import eu.datex2.schema._2_0rc2._2_0.OpenlrLineLocationReference;
import eu.datex2.schema._2_0rc2._2_0.OpenlrPointLocationReference;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import openlr.LocationReference;
import openlr.LocationType;
import openlr.StatusCode;
import openlr.datex2.Datex2Location;
import openlr.datex2.OpenLRDatex2Exception;
import openlr.datex2.XmlWriter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xml.sax.SAXException;

public class LocationReferenceImpl
implements LocationReference {
    private final String id;
    private final StatusCode returnCode;
    private final Datex2Location data;
    private final LocationType locType;
    private final int version;

    public LocationReferenceImpl(String i, OpenlrPointLocationReference d, int ver) {
        this(i, new Datex2Location(d), ver);
    }

    public LocationReferenceImpl(String i, OpenlrLineLocationReference d, int ver) {
        this(i, new Datex2Location(d), ver);
    }

    public LocationReferenceImpl(String i, Datex2Location d, int ver) {
        this.id = i;
        this.data = d;
        this.returnCode = null;
        this.version = ver;
        this.locType = d.getLocationType();
    }

    public LocationReferenceImpl(String i, StatusCode e, LocationType t, int ver) {
        this.id = i;
        this.data = null;
        this.returnCode = e;
        this.locType = t;
        this.version = ver;
    }

    public final StatusCode getReturnCode() {
        return this.returnCode;
    }

    public final String getID() {
        return this.id;
    }

    public final boolean isValid() {
        return this.returnCode == null && this.locType != LocationType.UNKNOWN;
    }

    public final Class<?> getDataClass() {
        return Datex2Location.class;
    }

    public final String getDataIdentifier() {
        return "datex2";
    }

    public final Object getLocationReferenceData() {
        if (this.isValid()) {
            return this.data;
        }
        return null;
    }

    public final void toStream(OutputStream os) throws IOException {
        XmlWriter writer = null;
        try {
            writer = new XmlWriter();
            writer.saveDatex2Location(this.data, os);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (OpenLRDatex2Exception e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    public final LocationType getLocationType() {
        return this.locType;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.returnCode).append((Object)this.data).append(this.version);
        return builder.toHashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof LocationReferenceImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LocationReferenceImpl other = (LocationReferenceImpl)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.locType, (Object)other.locType).append((Object)this.returnCode, (Object)other.returnCode).append((Object)this.data, (Object)other.data).append(this.version, other.version);
        return builder.isEquals();
    }
}

