/*
 * Decompiled with CFR 0.152.
 */
package openlr.collection;

import cern.colt.function.LongProcedure;
import cern.colt.map.AbstractMap;
import cern.colt.map.HashFunctions;

public abstract class OpenAbstractCollection
extends AbstractMap {
    private static final long serialVersionUID = 5163029925978869924L;
    private static final int HASH_BIT = Integer.MAX_VALUE;
    private static final float CAPACITY_FACTOR = 1.2f;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected long[] table;
    protected byte[] state;
    protected int freeEntries;

    public final boolean containsKey(long key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public final void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public final boolean forEachKey(LongProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    protected final int indexOfInsertion(long key) {
        long[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && tab[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected final int indexOfKey(long key) {
        long[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    @Override
    public final void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0f + 1.2f * (float)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    abstract void rehash(int var1);
}

