/*
 * Decompiled with CFR 0.152.
 */
package openlr.collection;

import cern.colt.list.ByteArrayList;
import cern.colt.list.LongArrayList;
import openlr.collection.OpenAbstractCollection;

public class OpenLongHashSet
extends OpenAbstractCollection {
    private static final long serialVersionUID = 4523482049259662861L;

    public OpenLongHashSet() {
        this(277);
    }

    public OpenLongHashSet(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenLongHashSet(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public final void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public final Object clone() {
        OpenLongHashSet copy = (OpenLongHashSet)super.clone();
        copy.table = (long[])copy.table.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    public final void keys(LongArrayList list) {
        list.setSize(this.distinct);
        long[] elements = list.elements();
        long[] tab = this.table;
        byte[] stat = this.state;
        int j = 0;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = tab[i];
        }
    }

    public final boolean put(long key) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key);
        }
        this.table[i] = key;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        long[] oldTable = this.table;
        byte[] oldState = this.state;
        long[] newTable = new long[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            long element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newState[index] = 1;
        }
    }

    public final boolean removeKey(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new long[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }
}

