/*
 * Decompiled with CFR 0.152.
 */
package openlr.collection;

import cern.colt.list.ByteArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.list.LongArrayList;
import openlr.collection.LongIntProcedure;
import openlr.collection.OpenAbstractCollection;

public class OpenLongIntHashMap
extends OpenAbstractCollection {
    private static final long serialVersionUID = -2371346990798084253L;
    private int[] values;

    public OpenLongIntHashMap() {
        this(277);
    }

    public OpenLongIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenLongIntHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public final void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        new IntArrayList(this.values).fillFromToWith(0, this.state.length - 1, 0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public final Object clone() {
        OpenLongIntHashMap copy = (OpenLongIntHashMap)super.clone();
        copy.table = (long[])copy.table.clone();
        copy.values = (int[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    public final boolean containsValue(int value) {
        return this.indexOfValue(value) >= 0;
    }

    public final boolean forEachPair(LongIntProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public final int get(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return Integer.MIN_VALUE;
        }
        return this.values[i];
    }

    protected final int indexOfValue(int value) {
        int[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    public final long keyOf(int value) {
        int i = this.indexOfValue(value);
        if (i < 0) {
            return Long.MIN_VALUE;
        }
        return this.table[i];
    }

    public final void keys(LongArrayList list) {
        list.setSize(this.distinct);
        long[] elements = list.elements();
        long[] tab = this.table;
        byte[] stat = this.state;
        int j = 0;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = tab[i];
        }
    }

    public final void pairsMatching(LongIntProcedure condition, LongArrayList keyList, IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    public final boolean put(long key, int value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        long[] oldTable = this.table;
        int[] oldValues = this.values;
        byte[] oldState = this.state;
        long[] newTable = new long[newCapacity];
        int[] newValues = new int[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            long element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
            newState[index] = 1;
        }
    }

    public final boolean removeKey(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        this.values[i] = 0;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new long[capacity];
        this.values = new int[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    public final void values(IntArrayList list) {
        list.setSize(this.distinct);
        int[] elements = list.elements();
        int[] val = this.values;
        byte[] stat = this.state;
        int j = 0;
        int i = stat.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = val[i];
        }
    }
}

