/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import openlr.PhysicalDecoder;
import openlr.decoder.LocationDatabase;
import openlr.map.MapDatabase;
import org.apache.commons.configuration.Configuration;

public final class OpenLRDecoderParameter {
    private final MapDatabase map;
    private final Configuration config;
    private final LocationDatabase ldb;
    private final List<PhysicalDecoder> physDecoder;

    private OpenLRDecoderParameter(Builder b) {
        this.map = b.map;
        this.config = b.config;
        this.ldb = b.ldb;
        this.physDecoder = b.physDecoder;
    }

    public MapDatabase getMapDatase() {
        return this.map;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LocationDatabase getLocationDatabase() {
        return this.ldb;
    }

    public boolean hasMapDatabase() {
        return this.map != null;
    }

    public boolean hasConfiguration() {
        return this.config != null;
    }

    public boolean hasLocationDatabase() {
        return this.ldb != null;
    }

    public boolean hasPhysicalDecoder() {
        return !this.physDecoder.isEmpty();
    }

    public List<PhysicalDecoder> getPhysicalDecoders() {
        return this.physDecoder;
    }

    public static final class Builder {
        private MapDatabase map;
        private Configuration config;
        private LocationDatabase ldb;
        private List<PhysicalDecoder> physDecoder = new ArrayList<PhysicalDecoder>();

        public Builder with(MapDatabase m) {
            this.map = m;
            return this;
        }

        public Builder with(Configuration c) {
            this.config = c;
            return this;
        }

        public Builder with(LocationDatabase l) {
            this.ldb = l;
            return this;
        }

        public Builder with(List<PhysicalDecoder> pd) {
            this.physDecoder = Collections.unmodifiableList(pd);
            return this;
        }

        public OpenLRDecoderParameter buildParameter() {
            return new OpenLRDecoderParameter(this);
        }
    }
}

