/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder;

import java.util.Collections;
import java.util.List;
import openlr.PhysicalEncoder;
import openlr.encoder.LRDatabase;
import openlr.map.MapDatabase;
import org.apache.commons.configuration.Configuration;

public final class OpenLREncoderParameter {
    private final MapDatabase map;
    private final Configuration config;
    private final LRDatabase lrdb;
    private final List<PhysicalEncoder> physEncoder;

    private OpenLREncoderParameter(Builder b) {
        this.map = b.map;
        this.config = b.config;
        this.lrdb = b.lrdb;
        this.physEncoder = b.physEncoder;
    }

    public MapDatabase getMapDatase() {
        return this.map;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LRDatabase getLRDatabase() {
        return this.lrdb;
    }

    public boolean hasMapDatabase() {
        return this.map != null;
    }

    public boolean hasConfiguration() {
        return this.config != null;
    }

    public boolean hasLRDatabase() {
        return this.lrdb != null;
    }

    public boolean hasPhysicalEncoder() {
        return !this.physEncoder.isEmpty();
    }

    public List<PhysicalEncoder> getPhysicalEncoders() {
        return this.physEncoder;
    }

    public static final class Builder {
        private MapDatabase map;
        private Configuration config;
        private LRDatabase lrdb;
        private List<PhysicalEncoder> physEncoder = Collections.emptyList();

        public Builder with(MapDatabase mdb) {
            this.map = mdb;
            return this;
        }

        public Builder with(Configuration c) {
            this.config = c;
            return this;
        }

        public Builder with(LRDatabase l) {
            this.lrdb = l;
            return this;
        }

        public Builder with(List<PhysicalEncoder> pe) {
            this.physEncoder = Collections.unmodifiableList(pe);
            return this;
        }

        public OpenLREncoderParameter buildParameter() {
            return new OpenLREncoderParameter(this);
        }
    }
}

