/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.List;
import openlr.LocationType;
import openlr.StatusCode;
import openlr.location.Location;
import openlr.location.data.AffectedLines;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.Line;

abstract class AbstractLocation
implements Location {
    protected final String id;
    protected final LocationType locType;
    protected final StatusCode retCode;
    private int hashCode;

    AbstractLocation(Location l) {
        this.id = l.getID();
        this.locType = l.getLocationType();
        this.retCode = l.getReturnCode();
    }

    AbstractLocation(String idValue, LocationType lt) {
        this.id = idValue;
        this.locType = lt;
        this.retCode = null;
    }

    AbstractLocation(String idValue, LocationType lt, StatusCode rt) {
        this.id = idValue;
        this.locType = lt;
        this.retCode = rt;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public final LocationType getLocationType() {
        return this.locType;
    }

    @Override
    public final StatusCode getReturnCode() {
        return this.retCode;
    }

    @Override
    public final boolean isValid() {
        return this.retCode == null;
    }

    public abstract int hashCode();

    protected final int getHashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.calculateHashCode();
        }
        return this.hashCode;
    }

    public abstract int calculateHashCode();

    public abstract boolean equals(Object var1);

    @Override
    public List<Line> getLocationLines() {
        return null;
    }

    @Override
    public int getPositiveOffset() {
        return -1;
    }

    @Override
    public int getNegativeOffset() {
        return -1;
    }

    @Override
    public Line getPoiLine() {
        return null;
    }

    @Override
    public boolean hasPositiveOffset() {
        return false;
    }

    @Override
    public boolean hasNegativeOffset() {
        return false;
    }

    @Override
    public GeoCoordinates getAccessPoint() {
        return null;
    }

    @Override
    public Orientation getOrientation() {
        return null;
    }

    @Override
    public GeoCoordinates getPointLocation() {
        return null;
    }

    @Override
    public SideOfRoad getSideOfRoad() {
        return null;
    }

    @Override
    public AffectedLines getAffectedLines() {
        return null;
    }

    @Override
    public List<GeoCoordinates> getCornerPoints() {
        return null;
    }

    @Override
    public GeoCoordinates getLowerLeftPoint() {
        return null;
    }

    @Override
    public GeoCoordinates getUpperRightPoint() {
        return null;
    }

    @Override
    public GeoCoordinates getCenterPoint() {
        return null;
    }

    @Override
    public long getRadius() {
        return -1L;
    }

    @Override
    public int getNumberOfColumns() {
        return -1;
    }

    @Override
    public int getNumberOfRows() {
        return -1;
    }
}

