/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CircleLocation
extends AbstractLocation {
    private final GeoCoordinates center;
    private final long radius;

    protected CircleLocation(String idString, double lonDeg, double latDeg, long r) throws InvalidMapDataException {
        super(idString, LocationType.CIRCLE);
        this.center = new GeoCoordinatesImpl(lonDeg, latDeg);
        this.radius = r;
    }

    CircleLocation(CircleLocation l) {
        super(l);
        this.center = l.getCenterPoint();
        this.radius = l.getRadius();
    }

    @Override
    public final GeoCoordinates getCenterPoint() {
        return this.center;
    }

    @Override
    public final long getRadius() {
        return this.radius;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        if (this.center != null) {
            sb.append(" center: ").append(this.center);
        }
        sb.append(" radius: ").append(this.radius);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.center).append(this.radius);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof CircleLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CircleLocation other = (CircleLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.center, (Object)other.center).append((Object)this.locType, (Object)other.locType).append(this.radius, other.radius);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

