/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.Collections;
import java.util.List;
import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.Line;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ClosedLineLocation
extends AbstractLocation {
    private final List<Line> lines;

    protected ClosedLineLocation(String idString, List<? extends Line> loc) {
        super(idString, LocationType.CLOSED_LINE);
        this.lines = Collections.unmodifiableList(loc);
    }

    ClosedLineLocation(ClosedLineLocation l) {
        super(l);
        this.lines = Collections.unmodifiableList(l.getLocationLines());
    }

    @Override
    public final List<Line> getLocationLines() {
        return this.lines;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" #lines: ").append(this.lines.size());
        sb.append(" [");
        for (int i = 0; i < this.lines.size(); ++i) {
            sb.append(this.lines.get(i).getID());
            if (i == this.lines.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append(this.lines);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof ClosedLineLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ClosedLineLocation other = (ClosedLineLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.lines, other.lines).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

