/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GeoCoordLocation
extends AbstractLocation {
    private final GeoCoordinates poi;

    GeoCoordLocation(String idString, double lonDeg, double latDeg) throws InvalidMapDataException {
        super(idString, LocationType.GEO_COORDINATES);
        this.poi = new GeoCoordinatesImpl(lonDeg, latDeg);
    }

    GeoCoordLocation(String idString, GeoCoordinates coord) {
        super(idString, LocationType.GEO_COORDINATES);
        this.poi = coord;
    }

    public GeoCoordLocation(GeoCoordLocation l) {
        super(l);
        this.poi = l.getPointLocation();
    }

    @Override
    public final GeoCoordinates getPointLocation() {
        return this.poi;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" poi: ").append(this.poi);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.poi);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof GeoCoordLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoCoordLocation other = (GeoCoordLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.poi, (Object)other.poi).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

