/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.List;
import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GridLocation
extends AbstractLocation {
    private final int numberOfColumns;
    private final int numberOfRows;
    private final RectangleCorners corners;

    protected GridLocation(String idString, double lowerLeftLonDeg, double lowerLeftLatDeg, double upperRightLonDeg, double upperRightLatDeg, int ncols, int nrows) throws InvalidMapDataException {
        super(idString, LocationType.GRID);
        GeoCoordinatesImpl lowerLeft = new GeoCoordinatesImpl(lowerLeftLonDeg, lowerLeftLatDeg);
        GeoCoordinatesImpl upperRight = new GeoCoordinatesImpl(upperRightLonDeg, upperRightLatDeg);
        this.numberOfColumns = ncols;
        this.numberOfRows = nrows;
        this.corners = new RectangleCorners((GeoCoordinates)lowerLeft, (GeoCoordinates)upperRight);
    }

    GridLocation(GridLocation l) {
        super(l);
        this.numberOfColumns = l.getNumberOfColumns();
        this.numberOfRows = l.getNumberOfRows();
        this.corners = l.corners;
    }

    @Override
    public final List<GeoCoordinates> getCornerPoints() {
        return this.corners.getCornerPoints();
    }

    @Override
    public final GeoCoordinates getLowerLeftPoint() {
        return this.corners.getLowerLeft();
    }

    @Override
    public final GeoCoordinates getUpperRightPoint() {
        return this.corners.getUpperRight();
    }

    @Override
    public final int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    @Override
    public final int getNumberOfRows() {
        return this.numberOfRows;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" corners: ").append(this.corners);
        sb.append(" NCOLS: ").append(this.numberOfColumns);
        sb.append(" NROWS: ").append(this.numberOfRows);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.corners).append((Object)this.corners).append(this.numberOfColumns).append(this.numberOfRows);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof GridLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GridLocation other = (GridLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.corners, (Object)other.corners).append((Object)this.locType, (Object)other.locType).append(this.numberOfColumns, other.numberOfColumns).append(this.numberOfRows, other.numberOfRows);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

