/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.Collections;
import java.util.List;
import openlr.LocationType;
import openlr.StatusCode;
import openlr.location.AbstractLocation;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.Line;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class InvalidLocation
extends AbstractLocation {
    private final List<Line> lines;
    private final int positiveOffset;
    private final int negativeOffset;
    private final GeoCoordinates geoCoord;
    private final GeoCoordinates accessPoint;
    private final SideOfRoad sideOfRoad;
    private final Orientation orientation;
    private final List<List<Line>> subRouteList;

    public InvalidLocation(String idValue, LocationType locTypeValue, StatusCode err, List<Line> loc, List<List<Line>> subRoutes, int pOff, int nOff, GeoCoordinates gC, GeoCoordinates aP, SideOfRoad sor, Orientation ori) {
        super(idValue, locTypeValue, err);
        this.lines = loc != null ? Collections.unmodifiableList(loc) : Collections.emptyList();
        this.subRouteList = subRoutes;
        this.positiveOffset = pOff;
        this.negativeOffset = nOff;
        this.geoCoord = gC;
        this.accessPoint = aP;
        this.sideOfRoad = sor;
        this.orientation = ori;
    }

    public InvalidLocation(String idValue, StatusCode err, LocationType locTypeValue) {
        this(idValue, locTypeValue, err, null, null, -1, -1, null, null, null, null);
    }

    public InvalidLocation(String idValue, StatusCode err, LocationType locTypeValue, List<List<Line>> subRoute) {
        this(idValue, locTypeValue, err, null, subRoute, -1, -1, null, null, null, null);
    }

    public InvalidLocation(String id, LocationType locTypeValue, StatusCode retCode, GeoCoordinates geoCoordinates, SideOfRoad sor, Orientation or) {
        this(id, locTypeValue, retCode, null, null, -1, -1, geoCoordinates, null, sor, or);
    }

    public InvalidLocation(String id, LocationType locTypeValue, StatusCode retCode, List<List<Line>> subRoutes, GeoCoordinates gC, SideOfRoad sor, Orientation or) {
        this(id, locTypeValue, retCode, null, subRoutes, -1, -1, gC, null, sor, or);
    }

    public InvalidLocation(String id, LocationType locTypeValue, StatusCode retCode, List<List<Line>> subRoutes, SideOfRoad sor, Orientation or) {
        this(id, locTypeValue, retCode, null, subRoutes, -1, -1, null, null, sor, or);
    }

    public InvalidLocation(String id, StatusCode retCode, LocationType locTypeValue, SideOfRoad sor, Orientation or) {
        this(id, locTypeValue, retCode, null, null, -1, -1, null, null, sor, or);
    }

    @Override
    public final List<Line> getLocationLines() {
        return this.lines;
    }

    public final List<List<Line>> getSubRouteList() {
        return this.subRouteList;
    }

    @Override
    public final int getPositiveOffset() {
        return this.positiveOffset;
    }

    @Override
    public final int getNegativeOffset() {
        return this.negativeOffset;
    }

    @Override
    public final GeoCoordinates getPointLocation() {
        return this.geoCoord;
    }

    @Override
    public final GeoCoordinates getAccessPoint() {
        return this.accessPoint;
    }

    @Override
    public final boolean hasNegativeOffset() {
        return this.negativeOffset > 0;
    }

    @Override
    public final boolean hasPositiveOffset() {
        return this.positiveOffset > 0;
    }

    @Override
    public final Line getPoiLine() {
        Line l = null;
        if (this.lines != null && !this.lines.isEmpty()) {
            l = this.lines.get(0);
        }
        return l;
    }

    @Override
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public final SideOfRoad getSideOfRoad() {
        return this.sideOfRoad;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" locType: ").append((Object)this.locType);
        if (this.lines != null && !this.lines.isEmpty()) {
            sb.append(" lines: [");
            for (int i = 0; i < this.lines.size(); ++i) {
                Line l = this.lines.get(i);
                sb.append(l.getID());
                if (i == this.lines.size() - 1) {
                    sb.append("]");
                    continue;
                }
                sb.append(", ");
            }
        }
        sb.append(" posOff: ").append(this.positiveOffset);
        sb.append(" negOff: ").append(this.negativeOffset);
        if (this.geoCoord != null) {
            sb.append(" geoCoord: ").append(this.geoCoord);
        }
        if (this.accessPoint != null) {
            sb.append(" accessPoint: ").append(this.accessPoint);
        }
        if (this.sideOfRoad != null) {
            sb.append(" sideOfRoad: ").append((Object)this.sideOfRoad);
        }
        if (this.orientation != null) {
            sb.append(" orientation: ").append((Object)this.orientation);
        }
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.negativeOffset).append(this.positiveOffset).append((Object)this.geoCoord).append((Object)this.accessPoint).append((Object)this.sideOfRoad).append((Object)this.orientation).append(this.lines).append(this.subRouteList).append((Object)this.locType);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof InvalidLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        InvalidLocation other = (InvalidLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.negativeOffset, other.negativeOffset).append(this.positiveOffset, other.positiveOffset).append((Object)this.geoCoord, (Object)other.geoCoord).append((Object)this.accessPoint, (Object)other.accessPoint).append((Object)this.sideOfRoad, (Object)other.sideOfRoad).append((Object)this.orientation, (Object)other.orientation).append(this.lines, other.lines).append(this.subRouteList, other.subRouteList).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

