/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.Collections;
import java.util.List;
import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.Line;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LineLocation
extends AbstractLocation {
    private final List<Line> lines;
    private final int posOff;
    private final int negOff;

    protected LineLocation(String idString, List<? extends Line> loc, int pOff, int nOff) {
        super(idString, LocationType.LINE_LOCATION);
        this.lines = Collections.unmodifiableList(loc);
        this.negOff = nOff;
        this.posOff = pOff;
    }

    LineLocation(String idString, List<Line> loc) {
        this(idString, loc, 0, 0);
    }

    public LineLocation(LineLocation l) {
        super(l);
        this.lines = Collections.unmodifiableList(l.getLocationLines());
        this.negOff = l.getNegativeOffset();
        this.posOff = l.getPositiveOffset();
    }

    @Override
    public final List<Line> getLocationLines() {
        return this.lines;
    }

    @Override
    public final int getPositiveOffset() {
        return this.posOff;
    }

    @Override
    public final int getNegativeOffset() {
        return this.negOff;
    }

    @Override
    public final boolean hasPositiveOffset() {
        return this.posOff > 0;
    }

    @Override
    public final boolean hasNegativeOffset() {
        return this.negOff > 0;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" #lines: ").append(this.lines.size());
        sb.append(" [");
        for (int i = 0; i < this.lines.size(); ++i) {
            Line currentLine = this.lines.get(i);
            if (currentLine != null) {
                sb.append(this.lines.get(i).getID());
            } else {
                sb.append("null");
            }
            if (i == this.lines.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        sb.append(" posOff: ").append(this.posOff);
        sb.append(" negOff: ").append(this.negOff);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.posOff).append(this.lines).append(this.negOff).append((Object)this.locType);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof LineLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LineLocation other = (LineLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.posOff, other.posOff).append(this.lines, other.lines).append(this.negOff, other.negOff).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

