/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.List;
import openlr.location.CircleLocation;
import openlr.location.ClosedLineLocation;
import openlr.location.GeoCoordLocation;
import openlr.location.GridLocation;
import openlr.location.LineLocation;
import openlr.location.Location;
import openlr.location.PoiAccessLocation;
import openlr.location.PointAlongLocation;
import openlr.location.PolygonLocation;
import openlr.location.RectangleLocation;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.utils.GeometryUtils;

public final class LocationFactory {
    private LocationFactory() {
        throw new UnsupportedOperationException();
    }

    public static Location createLineLocationWithOffsets(String idString, List<? extends Line> loc, int pOff, int nOff) {
        return new LineLocation(idString, loc, pOff, nOff);
    }

    public static Location createLineLocation(String idString, List<? extends Line> loc) {
        return new LineLocation(idString, loc, 0, 0);
    }

    public static Location createGeoCoordinateLocation(String idString, double lonDeg, double latDeg) throws InvalidMapDataException {
        return new GeoCoordLocation(idString, lonDeg, latDeg);
    }

    public static Location createPointAlongLineLocationWithSideAndOrientation(String idString, Line l, int poff, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, poff, s, o);
    }

    public static Location createPointAlongLineLocationWithSide(String idString, Line l, int poff, SideOfRoad s) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, poff, s, Orientation.getDefault());
    }

    public static Location createPointAlongLineLocationWithOrientation(String idString, Line l, int poff, Orientation o) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, poff, SideOfRoad.getDefault(), o);
    }

    public static Location createPointAlongLineLocation(String idString, Line l, int poff) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, poff, SideOfRoad.getDefault(), Orientation.getDefault());
    }

    public static Location createNodeLocationWithSide(String idString, Line l, SideOfRoad s) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, 0, s, Orientation.getDefault());
    }

    public static Location createNodeLocationWithOrientation(String idString, Line l, Orientation o) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, 0, SideOfRoad.getDefault(), o);
    }

    public static Location createNodeLocationWithSideAndOrientation(String idString, Line l, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, 0, s, o);
    }

    public static Location createNodeLocation(String idString, Line l) throws InvalidMapDataException {
        return new PointAlongLocation(idString, l, 0);
    }

    public static Location createPoiAccessLocationWithSideAndOrientation(String idString, Line l, int poff, double lonDeg, double latDeg, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, poff, lonDeg, latDeg, s, o);
    }

    public static Location createPoiAccessLocationWithSide(String idString, Line l, int poff, double lonDeg, double latDeg, SideOfRoad s) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, poff, lonDeg, latDeg, s, Orientation.getDefault());
    }

    public static Location createPoiAccessLocationWithOrientation(String idString, Line l, int poff, double lonDeg, double latDeg, Orientation o) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, poff, lonDeg, latDeg, SideOfRoad.getDefault(), o);
    }

    public static Location createPoiAccessLocation(String idString, Line l, int poff, double lonDeg, double latDeg) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, poff, lonDeg, latDeg, SideOfRoad.getDefault(), Orientation.getDefault());
    }

    public static Location createPoiAccessAtNodeLocationWithSideAndOrientation(String idString, Line l, double lonDeg, double latDeg, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, lonDeg, latDeg, s, o);
    }

    public static Location createPoiAccessAtNodeLocation(String idString, Line l, double lonDeg, double latDeg) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, 0, lonDeg, latDeg, SideOfRoad.getDefault(), Orientation.getDefault());
    }

    public static Location createPoiAccessAtNodeLocationWithSide(String idString, Line l, double lonDeg, double latDeg, SideOfRoad s) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, 0, lonDeg, latDeg, s, Orientation.getDefault());
    }

    public static Location createPoiAccessAtNodeLocationWithOrientation(String idString, Line l, double lonDeg, double latDeg, Orientation o) throws InvalidMapDataException {
        return new PoiAccessLocation(idString, l, 0, lonDeg, latDeg, SideOfRoad.getDefault(), o);
    }

    public static Location createCircleLocation(String idString, double lonDeg, double latDeg, long radius) throws InvalidMapDataException {
        return new CircleLocation(idString, lonDeg, latDeg, radius);
    }

    public static Location createRectangleLocation(String idString, double lowerLeftLonDeg, double lowerLeftLatDeg, double upperRightLonDeg, double upperRightLatDeg) throws InvalidMapDataException {
        return new RectangleLocation(idString, lowerLeftLonDeg, lowerLeftLatDeg, upperRightLonDeg, upperRightLatDeg);
    }

    public static Location createRectangleLocation(String string, GeoCoordinates rectangleLL, GeoCoordinates rectangleUR) throws InvalidMapDataException {
        return LocationFactory.createRectangleLocation(string, rectangleLL.getLongitudeDeg(), rectangleLL.getLatitudeDeg(), rectangleUR.getLongitudeDeg(), rectangleUR.getLatitudeDeg());
    }

    public static Location createGridLocationFromBasisCell(String idString, double lowerLeftLonDeg, double lowerLeftLatDeg, double upperRightLonDeg, double upperRightLatDeg, int ncols, int nrows) throws InvalidMapDataException {
        return new GridLocation(idString, lowerLeftLonDeg, lowerLeftLatDeg, upperRightLonDeg, upperRightLatDeg, ncols, nrows);
    }

    public static Location createGridLocationFromBasisCell(String idString, GeoCoordinates lowerLeft, GeoCoordinates upperRight, int ncols, int nrows) throws InvalidMapDataException {
        return LocationFactory.createGridLocationFromBasisCell(idString, lowerLeft.getLongitudeDeg(), lowerLeft.getLatitudeDeg(), upperRight.getLongitudeDeg(), upperRight.getLatitudeDeg(), ncols, nrows);
    }

    public static Location createGridLocationFromGridArea(String idString, double lowerLeftLonDeg, double lowerLeftLatDeg, double upperRightLonDeg, double upperRightLatDeg, int ncols, int nrows) throws InvalidMapDataException {
        GeoCoordinates basisUpperRight = GeometryUtils.scaleUpperRightCoordinate((double)lowerLeftLonDeg, (double)lowerLeftLatDeg, (double)upperRightLonDeg, (double)upperRightLatDeg, (double)(1.0 / (double)ncols), (double)(1.0 / (double)nrows));
        return new GridLocation(idString, lowerLeftLonDeg, lowerLeftLatDeg, basisUpperRight.getLongitudeDeg(), basisUpperRight.getLatitudeDeg(), ncols, nrows);
    }

    public static Location createGridLocationFromGridArea(String string, GeoCoordinates lowerLeft, GeoCoordinates upperRight, int columns, int rows) throws InvalidMapDataException {
        GeoCoordinates basisUpperRight = GeometryUtils.scaleUpperRightCoordinate((double)lowerLeft.getLongitudeDeg(), (double)lowerLeft.getLatitudeDeg(), (double)upperRight.getLongitudeDeg(), (double)upperRight.getLatitudeDeg(), (double)(1.0 / (double)columns), (double)(1.0 / (double)rows));
        return LocationFactory.createGridLocationFromBasisCell(string, lowerLeft.getLongitudeDeg(), lowerLeft.getLatitudeDeg(), basisUpperRight.getLongitudeDeg(), basisUpperRight.getLatitudeDeg(), columns, rows);
    }

    public static Location createPolygonLocation(String idString, List<? extends GeoCoordinates> cornerPoints) {
        return new PolygonLocation(idString, cornerPoints);
    }

    public static Location createClosedLineLocation(String idString, List<? extends Line> loc) {
        return new ClosedLineLocation(idString, loc);
    }
}

