/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import openlr.LocationType;
import openlr.location.PointLocation;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PoiAccessLocation
extends PointLocation {
    private final GeoCoordinates poi;

    protected PoiAccessLocation(String idString, Line l, int poff, double lonDeg, double latDeg, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        super(idString, LocationType.POI_WITH_ACCESS_POINT, l, poff, s, o);
        this.poi = new GeoCoordinatesImpl(lonDeg, latDeg);
    }

    PoiAccessLocation(String idString, Line l, int poff, double lonDeg, double latDeg, SideOfRoad s) throws InvalidMapDataException {
        this(idString, l, poff, lonDeg, latDeg, s, Orientation.getDefault());
    }

    PoiAccessLocation(String idString, Line l, int poff, double lonDeg, double latDeg, Orientation o) throws InvalidMapDataException {
        this(idString, l, poff, lonDeg, latDeg, SideOfRoad.getDefault(), o);
    }

    PoiAccessLocation(String idString, Line l, int poff, double lonDeg, double latDeg) throws InvalidMapDataException {
        this(idString, l, poff, lonDeg, latDeg, SideOfRoad.getDefault(), Orientation.getDefault());
    }

    PoiAccessLocation(String idString, Line l, double lonDeg, double latDeg, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        super(idString, LocationType.POI_WITH_ACCESS_POINT, l, 0, s, o);
        this.poi = new GeoCoordinatesImpl(lonDeg, latDeg);
    }

    PoiAccessLocation(String idString, Line l, double lonDeg, double latDeg) throws InvalidMapDataException {
        this(idString, l, 0, lonDeg, latDeg, SideOfRoad.getDefault(), Orientation.getDefault());
    }

    PoiAccessLocation(String idString, Line l, double lonDeg, double latDeg, SideOfRoad s) throws InvalidMapDataException {
        this(idString, l, 0, lonDeg, latDeg, s, Orientation.getDefault());
    }

    PoiAccessLocation(String idString, Line l, double lonDeg, double latDeg, Orientation o) throws InvalidMapDataException {
        this(idString, l, 0, lonDeg, latDeg, SideOfRoad.getDefault(), o);
    }

    public PoiAccessLocation(PoiAccessLocation l) {
        super(l);
        this.poi = l.getPointLocation();
    }

    @Override
    public final GeoCoordinates getPointLocation() {
        return this.poi;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" posOff: ").append(this.posOff);
        if (this.lineForPoint != null) {
            sb.append(" lineForPoint: ").append(this.lineForPoint.getID());
        }
        sb.append(" poi: ").append(this.poi);
        sb.append(" access: ").append(this.access);
        sb.append(" sideOfRoad: ").append((Object)this.sideOfRoad);
        sb.append(" orientation: ").append((Object)this.orientation);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.posOff).append((Object)this.lineForPoint).append((Object)this.poi).append((Object)this.access).append((Object)this.sideOfRoad).append((Object)this.orientation).append((Object)this.locType);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof PoiAccessLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PoiAccessLocation other = (PoiAccessLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.posOff, other.posOff).append((Object)this.lineForPoint, (Object)other.lineForPoint).append((Object)this.poi, (Object)other.poi).append((Object)this.access, (Object)other.access).append((Object)this.sideOfRoad, (Object)other.sideOfRoad).append((Object)this.orientation, (Object)other.orientation).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

