/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;

public abstract class PointLocation
extends AbstractLocation {
    protected final int posOff;
    protected final Line lineForPoint;
    protected final GeoCoordinates access;
    protected final SideOfRoad sideOfRoad;
    protected final Orientation orientation;

    protected PointLocation(String idString, LocationType lt, Line l, int poff, SideOfRoad s, Orientation o) throws InvalidMapDataException {
        super(idString, lt);
        this.posOff = poff;
        this.lineForPoint = l;
        this.access = poff == 0 ? l.getStartNode().getGeoCoordinates() : l.getGeoCoordinateAlongLine(poff);
        this.sideOfRoad = s;
        this.orientation = o;
    }

    public PointLocation(PointLocation l) {
        super(l);
        this.posOff = l.getPositiveOffset();
        this.lineForPoint = l.getPoiLine();
        this.access = l.getAccessPoint();
        this.sideOfRoad = l.getSideOfRoad();
        this.orientation = l.getOrientation();
    }

    @Override
    public final int getPositiveOffset() {
        return this.posOff;
    }

    @Override
    public final Line getPoiLine() {
        return this.lineForPoint;
    }

    @Override
    public final boolean hasPositiveOffset() {
        return this.posOff > 0;
    }

    @Override
    public final GeoCoordinates getAccessPoint() {
        return this.access;
    }

    @Override
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public final SideOfRoad getSideOfRoad() {
        return this.sideOfRoad;
    }
}

