/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.Collections;
import java.util.List;
import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.GeoCoordinates;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PolygonLocation
extends AbstractLocation {
    private final List<GeoCoordinates> corners;

    public PolygonLocation(String idString, List<? extends GeoCoordinates> loc) {
        super(idString, LocationType.POLYGON);
        this.corners = Collections.unmodifiableList(loc);
    }

    protected PolygonLocation(PolygonLocation l) {
        super(l);
        this.corners = Collections.unmodifiableList(l.getCornerPoints());
    }

    @Override
    public final List<GeoCoordinates> getCornerPoints() {
        return this.corners;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" corners: ");
        sb.append(" [");
        for (int i = 0; i < this.corners.size(); ++i) {
            sb.append(this.corners.get(i));
            if (i == this.corners.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append(this.corners);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof PolygonLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PolygonLocation other = (PolygonLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.corners, other.corners).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

