/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.util.List;
import openlr.LocationType;
import openlr.location.AbstractLocation;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RectangleLocation
extends AbstractLocation {
    private final RectangleCorners corners;

    public RectangleLocation(String idString, double lowerLeftLonDeg, double lowerLeftLatDeg, double upperRightLonDeg, double upperRightLatDeg) throws InvalidMapDataException {
        super(idString, LocationType.RECTANGLE);
        GeoCoordinatesImpl lowerLeft = new GeoCoordinatesImpl(lowerLeftLonDeg, lowerLeftLatDeg);
        GeoCoordinatesImpl upperRight = new GeoCoordinatesImpl(upperRightLonDeg, upperRightLatDeg);
        this.corners = new RectangleCorners((GeoCoordinates)lowerLeft, (GeoCoordinates)upperRight);
    }

    public RectangleLocation(RectangleLocation l) {
        super(l);
        this.corners = l.corners;
    }

    @Override
    public final List<GeoCoordinates> getCornerPoints() {
        return this.corners.getCornerPoints();
    }

    @Override
    public final GeoCoordinates getLowerLeftPoint() {
        return this.corners.getLowerLeft();
    }

    @Override
    public final GeoCoordinates getUpperRightPoint() {
        return this.corners.getUpperRight();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append((Object)this.locType);
        sb.append(" corners: ").append(this.corners);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.corners);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof RectangleLocation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RectangleLocation other = (RectangleLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.corners, (Object)other.corners).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

