/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import openlr.LocationType;
import openlr.location.Location;
import openlr.location.utils.LocationDataIterator;
import openlr.map.GeoCoordinates;
import openlr.map.Line;

public class LocationData {
    private List<Location> locations = new ArrayList<Location>();
    private List<String> errors = new ArrayList<String>();

    public final void addLocation(Location l) {
        if (l == null) {
            throw new IllegalArgumentException("Null location instance added to LocationData!");
        }
        this.locations.add(l);
    }

    public final void addError(String message) {
        this.errors.add(message);
    }

    public final int numberOfLocations() {
        return this.locations.size();
    }

    public final Set<Line> getAllLocationLines() {
        HashSet<Line> lines = new HashSet<Line>();
        for (Location ll : this.locations) {
            LocationType locType = ll.getLocationType();
            if (locType != LocationType.LINE_LOCATION && locType != LocationType.POI_WITH_ACCESS_POINT && locType != LocationType.POINT_ALONG_LINE) continue;
            List<Line> temp = ll.getLocationLines();
            Line poiLine = ll.getPoiLine();
            if (temp != null) {
                lines.addAll(temp);
            }
            if (poiLine == null) continue;
            lines.add(poiLine);
        }
        return lines;
    }

    public final Set<GeoCoordinates> getAllPointGeoCoordinates() {
        HashSet<GeoCoordinates> points = new HashSet<GeoCoordinates>();
        for (Location ll : this.locations) {
            LocationType locType = ll.getLocationType();
            if (locType != LocationType.GEO_COORDINATES && locType != LocationType.POI_WITH_ACCESS_POINT) continue;
            points.add(ll.getPointLocation());
        }
        return points;
    }

    public final List<Location> getLocations() {
        return this.locations;
    }

    public final boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public final int getNrOfErrors() {
        return this.errors.size();
    }

    public final List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("numberLocations: ").append(this.locations.size());
        return sb.toString();
    }

    public final Location getLocation(int index) {
        if (index < 0 || index >= this.locations.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.locations.get(index);
    }

    public final LocationDataIterator getIterator() {
        return new LocationDataIterator(this);
    }

    public final boolean hasLocations() {
        return this.locations.size() > 0;
    }
}

