/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import openlr.location.Location;
import openlr.location.utils.LocationData;

public class LocationDataIterator
implements ListIterator<Location> {
    private final LocationData data;
    private int currentLocation = -1;

    LocationDataIterator(LocationData locD) {
        this.data = locD;
    }

    public final int size() {
        return this.data.numberOfLocations();
    }

    public final int currentIndex() {
        return this.currentLocation;
    }

    public final Location current() {
        if (this.currentLocation >= 0 && this.currentLocation < this.data.numberOfLocations()) {
            return this.data.getLocation(this.currentLocation);
        }
        return null;
    }

    @Override
    public final Location next() {
        if (this.currentLocation < this.data.numberOfLocations() - 1) {
            ++this.currentLocation;
        } else {
            throw new NoSuchElementException("No element available for index " + this.currentLocation);
        }
        return this.current();
    }

    @Override
    public final Location previous() {
        if (this.currentLocation > 0) {
            --this.currentLocation;
        } else {
            throw new NoSuchElementException("No element available for index " + (this.currentLocation - 1));
        }
        return this.current();
    }

    @Override
    public final boolean hasPrevious() {
        return this.currentLocation > 0;
    }

    @Override
    public final boolean hasNext() {
        return this.currentLocation < this.data.numberOfLocations() - 1;
    }

    public final void reset() {
        this.currentLocation = -1;
    }

    public final Location setCurrent(int newIndex) {
        if (newIndex >= 0 && newIndex < this.data.numberOfLocations()) {
            this.currentLocation = newIndex;
            return this.current();
        }
        throw new IndexOutOfBoundsException("index out of bounds: " + newIndex);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Remove not supported by " + this.getClass().getName());
    }

    @Override
    public final int nextIndex() {
        return this.currentLocation + 1;
    }

    @Override
    public final int previousIndex() {
        return this.currentLocation;
    }

    @Override
    public final void set(Location e) {
        throw new UnsupportedOperationException("Set not supported by " + this.getClass().getName());
    }

    @Override
    public final void add(Location e) {
        throw new UnsupportedOperationException("Add not supported by " + this.getClass().getName());
    }
}

