/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import openlr.location.Location;
import openlr.location.utils.LocationData;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.CircleRW;
import openlr.location.utils.worker.ClosedLineRW;
import openlr.location.utils.worker.GeoCoordRW;
import openlr.location.utils.worker.GridRW;
import openlr.location.utils.worker.LineRW;
import openlr.location.utils.worker.PoiAccessRW;
import openlr.location.utils.worker.PointAlongRW;
import openlr.location.utils.worker.PolygonRW;
import openlr.location.utils.worker.RectangleRW;
import openlr.map.MapDatabase;

public final class LocationDataReader {
    private LocationDataReader() {
        throw new UnsupportedOperationException();
    }

    private static boolean skipDataLine(String line) {
        return line.isEmpty() || line.startsWith("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationData loadLocationData(File dataFile, MapDatabase mdb) throws IOException {
        assert (dataFile != null);
        assert (mdb != null);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(dataFile));
            LocationData locationData = LocationDataReader.loadLocationData(br, mdb);
            return locationData;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public static LocationData loadLocationData(BufferedReader reader, MapDatabase mdb) throws IOException {
        LocationData locData = new LocationData();
        String line = reader.readLine();
        while (line != null) {
            if (!LocationDataReader.skipDataLine(line = line.trim())) {
                try {
                    LocationDataReader.resolveDataLine(line, mdb, locData);
                }
                catch (LocationDataException e) {
                    locData.addError(e.getMessage());
                }
            }
            line = reader.readLine();
        }
        return locData;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resolveDataLine(String line, MapDatabase mdb, LocationData locData) throws LocationDataException {
        void var8_17;
        String[] parts = line.split(";");
        if (parts.length != 3) throw new LocationDataException("Invalid location string: " + line);
        String marker = parts[0];
        String id = parts[1];
        String features = parts[2];
        String[] featureList = features.split("\\s*,\\s*");
        if ("LIN".equals(marker)) {
            LineRW lineRW = new LineRW();
        } else if ("GEO".equals(marker)) {
            GeoCoordRW geoCoordRW = new GeoCoordRW();
        } else if ("POI".equals(marker)) {
            PoiAccessRW poiAccessRW = new PoiAccessRW();
        } else if ("PAL".equals(marker)) {
            PointAlongRW pointAlongRW = new PointAlongRW();
        } else if ("CIR".equals(marker)) {
            CircleRW circleRW = new CircleRW();
        } else if ("REC".equals(marker)) {
            RectangleRW rectangleRW = new RectangleRW();
        } else if ("GRI".equals(marker)) {
            GridRW gridRW = new GridRW();
        } else if ("POL".equals(marker)) {
            PolygonRW polygonRW = new PolygonRW();
        } else {
            if (!"CLL".equals(marker)) throw new LocationDataException("Unknown location marker");
            ClosedLineRW closedLineRW = new ClosedLineRW();
        }
        Location location = var8_17.readLocationString(id, featureList, mdb);
        locData.addLocation(location);
    }
}

