/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils;

import openlr.LocationType;
import openlr.location.Location;
import openlr.location.utils.worker.AbstractRW;
import openlr.location.utils.worker.CircleRW;
import openlr.location.utils.worker.ClosedLineRW;
import openlr.location.utils.worker.GeoCoordRW;
import openlr.location.utils.worker.GridRW;
import openlr.location.utils.worker.LineRW;
import openlr.location.utils.worker.PoiAccessRW;
import openlr.location.utils.worker.PointAlongRW;
import openlr.location.utils.worker.PolygonRW;
import openlr.location.utils.worker.RectangleRW;

public final class LocationDataWriter {
    private LocationDataWriter() {
        throw new UnsupportedOperationException();
    }

    public static String createLocationString(Location location) {
        LocationType lt = location.getLocationType();
        AbstractRW rw = null;
        switch (lt) {
            case LINE_LOCATION: {
                rw = new LineRW();
                break;
            }
            case CIRCLE: {
                rw = new CircleRW();
                break;
            }
            case CLOSED_LINE: {
                rw = new ClosedLineRW();
                break;
            }
            case GEO_COORDINATES: {
                rw = new GeoCoordRW();
                break;
            }
            case GRID: {
                rw = new GridRW();
                break;
            }
            case POI_WITH_ACCESS_POINT: {
                rw = new PoiAccessRW();
                break;
            }
            case POINT_ALONG_LINE: {
                rw = new PointAlongRW();
                break;
            }
            case POLYGON: {
                rw = new PolygonRW();
                break;
            }
            case RECTANGLE: {
                rw = new RectangleRW();
                break;
            }
            default: {
                return null;
            }
        }
        return rw.createLocationString(location);
    }
}

