/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;

public class CircleRW
extends AbstractRW {
    private static final int CIRCLE_LON_INDEX = 0;
    private static final int CIRCLE_LAT_INDEX = 1;
    private static final int CIRCLE_RADIUS_INDEX = 2;

    @Override
    public final String createLocationString(Location location) {
        double lon = location.getCenterPoint().getLongitudeDeg();
        double lat = location.getCenterPoint().getLatitudeDeg();
        long radius = location.getRadius();
        StringBuilder sb = new StringBuilder();
        sb.append("CIR").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(lon);
        sb.append(",");
        sb.append(lat);
        sb.append(",");
        sb.append(radius);
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        if (features.length < 3) {
            throw new LocationDataException(id + ": Not enough coordinates for circle");
        }
        try {
            double lon = Double.parseDouble(features[0]);
            double lat = Double.parseDouble(features[1]);
            int radius = Integer.parseInt(features[2]);
            return LocationFactory.createCircleLocation(id, lon, lat, radius);
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(id + ": " + e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new LocationDataException(id + ": Wrong coordinate format", e);
        }
    }
}

