/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import java.util.ArrayList;
import java.util.List;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.Line;
import openlr.map.MapDatabase;

public class ClosedLineRW
extends AbstractRW {
    private static final int LINE_LINES_START_INDEX = 0;

    @Override
    public final String createLocationString(Location location) {
        StringBuilder sb = new StringBuilder();
        sb.append("CLL").append(";");
        sb.append(location.getID());
        sb.append(";");
        List<Line> lines = location.getLocationLines();
        for (int i = 0; i < lines.size(); ++i) {
            sb.append(lines.get(i).getID());
            if (i == lines.size() - 1) continue;
            sb.append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        ArrayList<Line> lines = new ArrayList<Line>();
        Line prevLine = null;
        for (int i = 0; i < features.length; ++i) {
            String s = features[i];
            long lineID = Long.parseLong(s);
            Line line = mdb.getLine(lineID);
            if (line == null) {
                throw new LocationDataException(id + ": line " + lineID + " not found");
            }
            if (!this.isConnected(prevLine, line)) {
                throw new LocationDataException(id + ": line " + line + " not connected to previous line");
            }
            lines.add(line);
            prevLine = line;
        }
        return LocationFactory.createClosedLineLocation(id, lines);
    }
}

