/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.map.utils.GeometryUtils;

public class GeoCoordRW
extends AbstractRW {
    private static final int GEOCOORD_LON_INDEX = 0;
    private static final int GEOCOORD_LAT_INDEX = 1;

    @Override
    public final String createLocationString(Location location) {
        double lon = location.getPointLocation().getLongitudeDeg();
        double lat = location.getPointLocation().getLatitudeDeg();
        StringBuilder sb = new StringBuilder();
        sb.append("GEO").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(lon);
        sb.append(",");
        sb.append(lat);
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        if (features.length < 2) {
            throw new LocationDataException(id + ": Not enough coordinates for circle");
        }
        try {
            double longitude = Double.parseDouble(features[0]);
            double latitude = Double.parseDouble(features[1]);
            if (!GeometryUtils.checkCoordinateBounds((double)longitude, (double)latitude)) {
                throw new LocationDataException(id + ": coordinates out of bounds");
            }
            return LocationFactory.createGeoCoordinateLocation(id, longitude, latitude);
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(id + ": " + e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new LocationDataException(id + ": Wrong coordinate format", e);
        }
    }
}

