/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;

public class GridRW
extends AbstractRW {
    private static final int GRID_LEFT_LON_INDEX = 0;
    private static final int GRID_LEFT_LAT_INDEX = 1;
    private static final int GRID_RIGHT_LON_INDEX = 2;
    private static final int GRID_RIGHT_LAT_INDEX = 3;
    private static final int GRID_ROWS_INDEX = 4;
    private static final int GRID_COLUMNS_INDEX = 5;

    @Override
    public final String createLocationString(Location location) {
        GeoCoordinates ll = location.getLowerLeftPoint();
        GeoCoordinates ur = location.getUpperRightPoint();
        StringBuilder sb = new StringBuilder();
        sb.append("GRI").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(ll.getLongitudeDeg());
        sb.append(",");
        sb.append(ll.getLatitudeDeg());
        sb.append(",");
        sb.append(ur.getLongitudeDeg());
        sb.append(",");
        sb.append(ur.getLatitudeDeg());
        sb.append(",");
        sb.append(location.getNumberOfRows());
        sb.append(",");
        sb.append(location.getNumberOfColumns());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        if (features.length < 6) {
            throw new LocationDataException(id + ": Not enough attributes for grid");
        }
        try {
            double leftmostLonDeg = Double.parseDouble(features[0]);
            double leftmostLatDeg = Double.parseDouble(features[1]);
            double rightmostLonDeg = Double.parseDouble(features[2]);
            double rightmostLatDeg = Double.parseDouble(features[3]);
            int nrows = Integer.parseInt(features[4]);
            int ncolumns = Integer.parseInt(features[5]);
            return LocationFactory.createGridLocationFromBasisCell(id, leftmostLonDeg, leftmostLatDeg, rightmostLonDeg, rightmostLatDeg, ncolumns, nrows);
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(e);
        }
        catch (NumberFormatException e) {
            throw new LocationDataException(id + ": Wrong coordinate format", e);
        }
    }
}

