/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import java.util.ArrayList;
import java.util.List;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.Line;
import openlr.map.MapDatabase;

public class LineRW
extends AbstractRW {
    private static final int MIN_LENGTH_FEATURES = 3;
    private static final int LINE_POFF_INDEX = 0;
    private static final int LINE_NOFF_INDEX = 1;
    private static final int LINE_LINES_START_INDEX = 2;

    @Override
    public final String createLocationString(Location location) {
        List<Line> lines = location.getLocationLines();
        int pOff = location.getPositiveOffset();
        int nOff = location.getNegativeOffset();
        StringBuilder sb = new StringBuilder();
        sb.append("LIN").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(pOff);
        sb.append(",");
        sb.append(nOff);
        sb.append(",");
        for (int i = 0; i < lines.size(); ++i) {
            sb.append(lines.get(i).getID());
            if (i == lines.size() - 1) continue;
            sb.append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        int nOff;
        int pOff;
        if (id == null || features == null || features.length < 3) {
            throw new LocationDataException(id + ": invalid parameters");
        }
        String poffString = features[0];
        String noffString = features[1];
        try {
            pOff = Integer.parseInt(poffString);
            nOff = Integer.parseInt(noffString);
        }
        catch (NumberFormatException e) {
            throw new LocationDataException(id + ": Offsets \"" + poffString + ", " + noffString + "\" could not be converted to numbers.");
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        Line prevLine = null;
        for (int i = 2; i < features.length; ++i) {
            String s = features[i];
            try {
                long lineID = Long.parseLong(s);
                Line line = mdb.getLine(lineID);
                if (line == null) {
                    throw new LocationDataException(id + ": line " + lineID + " not found");
                }
                if (!this.isConnected(prevLine, line)) {
                    throw new LocationDataException(id + ": line " + line + " not connected to previous line");
                }
                lines.add(line);
                prevLine = line;
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new LocationDataException(id + ": Line ID \"" + s + "\" could not be converted to a number.");
            }
        }
        return LocationFactory.createLineLocationWithOffsets(id, lines, pOff, nOff);
    }
}

