/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import java.util.List;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.GeometryUtils;

public class PoiAccessRW
extends AbstractRW {
    private static final int POI_ACCESS_LINE_INDEX = 0;
    private static final int POI_ACCESS_OFFSET_INDEX = 1;
    private static final int POI_ACCESS_LON_INDEX = 2;
    private static final int POI_ACCESS_LAT_INDEX = 3;
    private static final int POI_ACCESS_SOR_INDEX = 4;
    private static final int POI_ACCESS_ORI_INDEX = 5;

    @Override
    public final String createLocationString(Location location) {
        Line l = location.getPoiLine();
        int poff = location.getPositiveOffset();
        double lon = location.getPointLocation().getLongitudeDeg();
        double lat = location.getPointLocation().getLatitudeDeg();
        SideOfRoad sor = location.getSideOfRoad();
        Orientation o = location.getOrientation();
        StringBuilder sb = new StringBuilder();
        sb.append("POI").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(l.getID());
        sb.append(",");
        sb.append(poff);
        sb.append(",");
        sb.append(lon);
        sb.append(",");
        sb.append(lat);
        sb.append(",");
        sb.append(sor.ordinal());
        sb.append(",");
        sb.append(o.ordinal());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        double latitude;
        if (features.length < 6) {
            throw new LocationDataException(id + ": Invalid input string");
        }
        long lineID = Long.parseLong(features[0]);
        Line line = mdb.getLine(lineID);
        if (line == null) {
            throw new LocationDataException(id + ": line " + lineID + " not found");
        }
        int offset = Integer.parseInt(features[1]);
        double longitude = Double.parseDouble(features[2]);
        if (!GeometryUtils.checkCoordinateBounds((double)longitude, (double)(latitude = Double.parseDouble(features[3])))) {
            throw new LocationDataException("coordinates out of bounds");
        }
        int so = Integer.parseInt(features[4]);
        List<SideOfRoad> sValues = SideOfRoad.getSideOfRoadValues();
        if (so < 0 || so > sValues.size()) {
            throw new LocationDataException(id + ": invalid side of road");
        }
        SideOfRoad s = sValues.get(so);
        int oo = Integer.parseInt(features[5]);
        List<Orientation> oValues = Orientation.getOrientationValues();
        if (oo < 0 || oo > oValues.size()) {
            throw new LocationDataException(id + ": invalid orientation");
        }
        Orientation o = oValues.get(oo);
        try {
            return LocationFactory.createPoiAccessLocationWithSideAndOrientation(id, line, offset, longitude, latitude, s, o);
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(id + ": " + e.getMessage());
        }
    }
}

