/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import java.util.List;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;

public class PointAlongRW
extends AbstractRW {
    private static final int POINT_ALONG_LINE_INDEX = 0;
    private static final int POINT_ALONG_OFFSET_INDEX = 1;
    private static final int POINT_ALONG_SOR_INDEX = 2;
    private static final int POINT_ALONG_ORI_INDEX = 3;

    @Override
    public final String createLocationString(Location location) {
        Line l = location.getPoiLine();
        int poff = location.getPositiveOffset();
        SideOfRoad sor = location.getSideOfRoad();
        Orientation o = location.getOrientation();
        StringBuilder sb = new StringBuilder();
        sb.append("PAL").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(l.getID());
        sb.append(",");
        sb.append(poff);
        sb.append(",");
        sb.append(sor.ordinal());
        sb.append(",");
        sb.append(o.ordinal());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        if (features.length < 4) {
            throw new LocationDataException(id + ": Invalid input string");
        }
        long lineID = Long.parseLong(features[0]);
        Line line = mdb.getLine(lineID);
        if (line == null) {
            throw new LocationDataException("line id not found " + lineID);
        }
        int offset = Integer.parseInt(features[1]);
        int so = Integer.parseInt(features[2]);
        List<SideOfRoad> sValues = SideOfRoad.getSideOfRoadValues();
        if (so < 0 || so > sValues.size()) {
            throw new LocationDataException(id + ": invalid side of road");
        }
        SideOfRoad s = sValues.get(so);
        int oo = Integer.parseInt(features[3]);
        List<Orientation> oValues = Orientation.getOrientationValues();
        if (oo < 0 || oo > oValues.size()) {
            throw new LocationDataException(id + ": invalid orientation");
        }
        Orientation o = oValues.get(oo);
        try {
            return LocationFactory.createPointAlongLineLocationWithSideAndOrientation(id, line, offset, s, o);
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(id + ": " + e.getMessage());
        }
    }
}

