/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import java.util.ArrayList;
import java.util.List;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;

public class PolygonRW
extends AbstractRW {
    @Override
    public final String createLocationString(Location location) {
        StringBuilder sb = new StringBuilder();
        sb.append("POL").append(";");
        sb.append(location.getID());
        sb.append(";");
        List<GeoCoordinates> cornerPoints = location.getCornerPoints();
        for (int i = 0; i < cornerPoints.size(); ++i) {
            sb.append(cornerPoints.get(i).getLongitudeDeg());
            sb.append(",");
            sb.append(cornerPoints.get(i).getLatitudeDeg());
            if (i == cornerPoints.size() - 1) continue;
            sb.append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        ArrayList<GeoCoordinatesImpl> geoCornerPoints = new ArrayList<GeoCoordinatesImpl>();
        try {
            for (int i = 0; i < features.length; ++i) {
                try {
                    double lon = Double.parseDouble(features[i]);
                    double lat = Double.parseDouble(features[++i]);
                    GeoCoordinatesImpl g = new GeoCoordinatesImpl(lon, lat);
                    geoCornerPoints.add(g);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new LocationDataException(id + ": Wrong coordinate format", e);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new LocationDataException(id + ": Not enough coordinates for rectangle");
                }
            }
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(id + ": " + e.getMessage());
        }
        if (geoCornerPoints.isEmpty()) {
            throw new LocationDataException(id + ": no valid corner points found");
        }
        return LocationFactory.createPolygonLocation(id, geoCornerPoints);
    }
}

