/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils.worker;

import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.utils.LocationDataException;
import openlr.location.utils.worker.AbstractRW;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;

public class RectangleRW
extends AbstractRW {
    private static final int RECTANGLE_LEFT_LON_INDEX = 0;
    private static final int RECTANGLE_LEFT_LAT_INDEX = 1;
    private static final int RECTANGLE_RIGHT_LON_INDEX = 2;
    private static final int RECTANGLE_RIGHT_LAT_INDEX = 3;

    @Override
    public final String createLocationString(Location location) {
        GeoCoordinates ll = location.getLowerLeftPoint();
        GeoCoordinates ur = location.getUpperRightPoint();
        StringBuilder sb = new StringBuilder();
        sb.append("REC").append(";");
        sb.append(location.getID());
        sb.append(";");
        sb.append(ll.getLongitudeDeg());
        sb.append(",");
        sb.append(ll.getLatitudeDeg());
        sb.append(",");
        sb.append(ur.getLongitudeDeg());
        sb.append(",");
        sb.append(ur.getLatitudeDeg());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public final Location readLocationString(String id, String[] features, MapDatabase mdb) throws LocationDataException {
        if (features.length < 4) {
            throw new LocationDataException(id + ": Not enough coordinates for rectangle");
        }
        try {
            double leftLon = Double.parseDouble(features[0]);
            double leftLat = Double.parseDouble(features[1]);
            double rightLon = Double.parseDouble(features[2]);
            double rightLat = Double.parseDouble(features[3]);
            return LocationFactory.createRectangleLocation(id, leftLon, leftLat, rightLon, rightLat);
        }
        catch (InvalidMapDataException e) {
            throw new LocationDataException(id + ": " + e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new LocationDataException(id + ": Wrong coordinate format", e);
        }
    }
}

