/*
 * Decompiled with CFR 0.152.
 */
package openlr.properties;

import java.io.File;
import java.io.InputStream;
import openlr.OpenLRProcessingException;
import openlr.properties.OpenLRPropertyException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

public final class OpenLRPropertiesReader {
    private static final Logger LOG = Logger.getLogger(OpenLRPropertiesReader.class);

    private OpenLRPropertiesReader() {
        throw new UnsupportedOperationException();
    }

    public static FileConfiguration loadPropertiesFromFile(File file) throws OpenLRPropertyException {
        Object conf;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"load OpenLR properties file");
        }
        if (file == null) {
            LOG.error((Object)"Cannot find the OpenLR properties file.");
            throw new OpenLRPropertyException(OpenLRPropertyException.PropertyError.PROPERTIES_FILE_NOT_FOUND);
        }
        try {
            conf = file.getName().endsWith(".properties") ? new PropertiesConfiguration(file) : new XMLConfiguration(file);
        }
        catch (ConfigurationException e) {
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.MISSING_PROPERTY, (Throwable)e);
        }
        return conf;
    }

    public static FileConfiguration loadPropertiesFromStream(InputStream iStream, boolean isXML) throws OpenLRPropertyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"load OpenLR properties file");
        }
        if (iStream == null) {
            LOG.error((Object)"Cannot find the OpenLR properties file.");
            throw new OpenLRPropertyException(OpenLRPropertyException.PropertyError.PROPERTIES_FILE_NOT_FOUND);
        }
        try {
            Object conf = isXML ? new XMLConfiguration() : new PropertiesConfiguration();
            conf.load(iStream);
            return conf;
        }
        catch (ConfigurationException e) {
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.MISSING_PROPERTY, (Throwable)e);
        }
    }
}

