/*
 * Decompiled with CFR 0.152.
 */
package openlr.properties;

import java.util.Map;
import openlr.OpenLRProcessingException;
import openlr.properties.OpenLRProperty;
import openlr.properties.OpenLRPropertyException;
import openlr.properties.PropertyType;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

public final class OpenLRPropertyAccess {
    private static final Logger LOG = Logger.getLogger(OpenLRPropertyAccess.class);

    private OpenLRPropertyAccess() {
        throw new UnsupportedOperationException();
    }

    public static int getIntegerPropertyValue(Configuration properties, OpenLRProperty property) throws OpenLRPropertyException {
        if (property.getPropertyType() != PropertyType.INTEGER) {
            String error = property.getKey() + " is not an integer";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        if (properties == null) {
            return (Integer)property.getDefault();
        }
        return properties.getInt(property.getKey(), ((Integer)property.getDefault()).intValue());
    }

    public static float getFloatPropertyValue(Configuration properties, OpenLRProperty property) throws OpenLRPropertyException {
        if (property.getPropertyType() != PropertyType.FLOAT) {
            String error = property.getKey() + " is not a float";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        if (properties == null) {
            return ((Float)property.getDefault()).floatValue();
        }
        return properties.getFloat(property.getKey(), (Float)property.getDefault()).floatValue();
    }

    public static String getStringPropertyValue(Configuration properties, OpenLRProperty property) throws OpenLRPropertyException {
        if (property.getPropertyType() != PropertyType.STRING) {
            String error = property.getKey() + " is not an integer";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        if (properties == null) {
            return (String)property.getDefault();
        }
        return properties.getString(property.getKey(), (String)property.getDefault());
    }

    public static boolean getBooleanPropertyValue(Configuration properties, OpenLRProperty property) throws OpenLRProcessingException {
        if (property.getPropertyType() != PropertyType.BOOLEAN) {
            String error = property.getKey() + " is not a boolean";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        if (properties == null) {
            return (Boolean)property.getDefault();
        }
        return properties.getBoolean(property.getKey(), (Boolean)property.getDefault());
    }

    public static int getIntegerPropertyValueById(Configuration properties, OpenLRProperty property, String id) throws OpenLRProcessingException {
        if (property.getPropertyType() != PropertyType.INTEGER_BY_ID) {
            String error = property.getKey() + " is not an integer by id";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        if (properties == null) {
            return (Integer)property.getDefault();
        }
        return properties.getInt(property.getKey() + "." + id, ((Integer)property.getDefault()).intValue());
    }

    public static int getIntegerPropertyValueFromMap(Configuration properties, OpenLRProperty property, String id) throws OpenLRProcessingException {
        if (property.getPropertyType() != PropertyType.INTEGER_BY_MAP) {
            String error = property.getKey() + " is not an integer from map";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        Map data = (Map)property.getDefault();
        Integer defaultValue = (Integer)data.get(id);
        if (properties == null) {
            if (defaultValue == null) {
                String error = property.getKey() + "[" + id + "] has no default value";
                LOG.error((Object)error);
                throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
            }
            return (Integer)data.get(id);
        }
        if (!properties.containsKey(property.getKey() + "." + id) && defaultValue == null) {
            String error = property.getKey() + "[" + id + "] has no value";
            LOG.error((Object)error);
            throw new OpenLRPropertyException((OpenLRProcessingException.ErrorCode)OpenLRPropertyException.PropertyError.INVALID_PROPERTY_TYPE, error);
        }
        return properties.getInt(property.getKey() + "." + id, defaultValue.intValue());
    }
}

