/*
 * Decompiled with CFR 0.152.
 */
package openlr.rawLocRef;

import java.util.Collections;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.rawLocRef.RawLocationReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RawClosedLineLocRef
extends RawLocationReference {
    private final List<LocationReferencePoint> points;

    public RawClosedLineLocRef(String idValue, List<? extends LocationReferencePoint> locRefPoints) {
        super(idValue, LocationType.CLOSED_LINE);
        this.points = Collections.unmodifiableList(locRefPoints);
    }

    @Override
    public final List<LocationReferencePoint> getLocationReferencePoints() {
        return this.points;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" locType: ").append((Object)this.locType);
        if (this.points != null && !this.points.isEmpty()) {
            sb.append(" points: [");
            for (int i = 0; i < this.points.size(); ++i) {
                sb.append(this.points.get(i));
                if (i == this.points.size() - 1) {
                    sb.append("]");
                    continue;
                }
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append(this.points);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof RawClosedLineLocRef)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RawClosedLineLocRef other = (RawClosedLineLocRef)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.locType, (Object)other.locType).append(this.points, other.points);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

