/*
 * Decompiled with CFR 0.152.
 */
package openlr.rawLocRef;

import openlr.LocationType;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RawGridLocRef
extends RawLocationReference {
    private final GeoCoordinates lowerLeft;
    private final GeoCoordinates upperRight;
    private final int ncols;
    private final int nrows;

    public RawGridLocRef(String idValue, GeoCoordinates ll, GeoCoordinates ur, int cols, int rows) {
        super(idValue, LocationType.GRID);
        this.lowerLeft = ll;
        this.upperRight = ur;
        this.ncols = cols;
        this.nrows = rows;
    }

    @Override
    public final GeoCoordinates getLowerLeftPoint() {
        return this.lowerLeft;
    }

    @Override
    public final GeoCoordinates getUpperRightPoint() {
        return this.upperRight;
    }

    @Override
    public final int getNumberOfColumns() {
        return this.ncols;
    }

    @Override
    public final int getNumberOfRows() {
        return this.nrows;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" locType: ").append((Object)this.locType);
        if (this.lowerLeft != null) {
            sb.append(" lower left: ");
            sb.append(this.lowerLeft);
        }
        if (this.upperRight != null) {
            sb.append(" upper right: ");
            sb.append(this.upperRight);
        }
        sb.append(" number of cols: ").append(this.ncols);
        sb.append(" number of rows: ").append(this.nrows);
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.lowerLeft).append((Object)this.locType).append((Object)this.upperRight).append(this.ncols).append(this.nrows);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof RawGridLocRef)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RawGridLocRef other = (RawGridLocRef)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.upperRight, (Object)other.upperRight).append((Object)this.locType, (Object)other.locType).append((Object)this.lowerLeft, (Object)other.lowerLeft).append(this.ncols, other.ncols).append(this.nrows, other.nrows);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

