/*
 * Decompiled with CFR 0.152.
 */
package openlr.rawLocRef;

import java.util.Collections;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.rawLocRef.RawLocationReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RawLineLocRef
extends RawLocationReference {
    private final List<LocationReferencePoint> points;
    private final Offsets offsets;

    public RawLineLocRef(String idValue, List<? extends LocationReferencePoint> locRefPoints, Offsets od) {
        super(idValue, LocationType.LINE_LOCATION);
        this.points = Collections.unmodifiableList(locRefPoints);
        this.offsets = od;
    }

    @Override
    public final List<LocationReferencePoint> getLocationReferencePoints() {
        return this.points;
    }

    @Override
    public final Offsets getOffsets() {
        return this.offsets;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" locType: ").append((Object)this.locType);
        if (this.points != null && !this.points.isEmpty()) {
            sb.append(" points: ").append(this.points);
        }
        if (this.offsets != null) {
            sb.append(" offsets: ").append(this.offsets);
        }
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.offsets).append(this.points);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof RawLineLocRef)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RawLineLocRef other = (RawLineLocRef)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.locType, (Object)other.locType).append((Object)this.offsets, (Object)other.offsets).append(this.points, other.points);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

