/*
 * Decompiled with CFR 0.152.
 */
package openlr.rawLocRef;

import java.util.Collections;
import java.util.List;
import openlr.LocationType;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RawPolygonLocRef
extends RawLocationReference {
    private final List<GeoCoordinates> corners;

    public RawPolygonLocRef(String idValue, List<? extends GeoCoordinates> c) {
        super(idValue, LocationType.POLYGON);
        this.corners = Collections.unmodifiableList(c);
    }

    @Override
    public final List<GeoCoordinates> getCornerPoints() {
        return this.corners;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" locType: ").append((Object)this.locType);
        sb.append(" corners: ");
        sb.append(" [");
        for (int i = 0; i < this.corners.size(); ++i) {
            sb.append(this.corners.get(i));
            if (i == this.corners.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public final int calculateHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.corners).append((Object)this.locType);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof RawPolygonLocRef)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RawPolygonLocRef other = (RawPolygonLocRef)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.corners, other.corners).append((Object)this.locType, (Object)other.locType);
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        return this.getHashCode();
    }
}

