/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.location;

import openlr.location.CircleLocation;
import openlr.location.ClosedLineLocation;
import openlr.location.GeoCoordLocation;
import openlr.location.GridLocation;
import openlr.location.LineLocation;
import openlr.location.Location;
import openlr.location.PoiAccessLocation;
import openlr.location.PointAlongLocation;
import openlr.location.PolygonLocation;
import openlr.location.RectangleLocation;

public abstract class LocationProcessor<T> {
    public final T process(Location location) {
        T result;
        switch (location.getLocationType()) {
            case LINE_LOCATION: {
                result = this.process(LocationProcessor.castTo(LineLocation.class, location));
                break;
            }
            case GEO_COORDINATES: {
                result = this.process(LocationProcessor.castTo(GeoCoordLocation.class, location));
                break;
            }
            case POINT_ALONG_LINE: {
                result = this.process(LocationProcessor.castTo(PointAlongLocation.class, location));
                break;
            }
            case POI_WITH_ACCESS_POINT: {
                result = this.process(LocationProcessor.castTo(PoiAccessLocation.class, location));
                break;
            }
            case RECTANGLE: {
                result = this.process(LocationProcessor.castTo(RectangleLocation.class, location));
                break;
            }
            case POLYGON: {
                result = this.process(LocationProcessor.castTo(PolygonLocation.class, location));
                break;
            }
            case CIRCLE: {
                result = this.process(LocationProcessor.castTo(CircleLocation.class, location));
                break;
            }
            case GRID: {
                result = this.process(LocationProcessor.castTo(GridLocation.class, location));
                break;
            }
            case CLOSED_LINE: {
                result = this.process(LocationProcessor.castTo(ClosedLineLocation.class, location));
                break;
            }
            case UNKNOWN: {
                result = this.processUnknown(location);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected location type " + (Object)((Object)location.getLocationType()));
            }
        }
        return result;
    }

    public abstract T process(LineLocation var1);

    public abstract T process(GeoCoordLocation var1);

    public abstract T process(PointAlongLocation var1);

    public abstract T process(PoiAccessLocation var1);

    public abstract T process(RectangleLocation var1);

    public abstract T process(PolygonLocation var1);

    public abstract T process(CircleLocation var1);

    public abstract T process(GridLocation var1);

    public abstract T process(ClosedLineLocation var1);

    public abstract T processUnknown(Location var1);

    private static <T extends Location> T castTo(Class<T> locationClass, Location location) {
        if (locationClass.isInstance(location)) {
            return (T)((Location)locationClass.cast(location));
        }
        throw new IllegalArgumentException("Could not cast " + location.getClass() + " to " + locationClass);
    }
}

