/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.locref;

import openlr.rawLocRef.RawCircleLocRef;
import openlr.rawLocRef.RawClosedLineLocRef;
import openlr.rawLocRef.RawGeoCoordLocRef;
import openlr.rawLocRef.RawGridLocRef;
import openlr.rawLocRef.RawLineLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPoiAccessLocRef;
import openlr.rawLocRef.RawPointAlongLocRef;
import openlr.rawLocRef.RawPolygonLocRef;
import openlr.rawLocRef.RawRectangleLocRef;

public abstract class LocationReferenceProcessor<T> {
    public final T process(RawLocationReference locationReference) {
        T result;
        switch (locationReference.getLocationType()) {
            case LINE_LOCATION: {
                result = this.process(LocationReferenceProcessor.castTo(RawLineLocRef.class, locationReference));
                break;
            }
            case GEO_COORDINATES: {
                result = this.process(LocationReferenceProcessor.castTo(RawGeoCoordLocRef.class, locationReference));
                break;
            }
            case POINT_ALONG_LINE: {
                result = this.process(LocationReferenceProcessor.castTo(RawPointAlongLocRef.class, locationReference));
                break;
            }
            case POI_WITH_ACCESS_POINT: {
                result = this.process(LocationReferenceProcessor.castTo(RawPoiAccessLocRef.class, locationReference));
                break;
            }
            case RECTANGLE: {
                result = this.process(LocationReferenceProcessor.castTo(RawRectangleLocRef.class, locationReference));
                break;
            }
            case POLYGON: {
                result = this.process(LocationReferenceProcessor.castTo(RawPolygonLocRef.class, locationReference));
                break;
            }
            case CIRCLE: {
                result = this.process(LocationReferenceProcessor.castTo(RawCircleLocRef.class, locationReference));
                break;
            }
            case GRID: {
                result = this.process(LocationReferenceProcessor.castTo(RawGridLocRef.class, locationReference));
                break;
            }
            case CLOSED_LINE: {
                result = this.process(LocationReferenceProcessor.castTo(RawClosedLineLocRef.class, locationReference));
                break;
            }
            case UNKNOWN: {
                result = this.processUnknown(locationReference);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected location reference type " + (Object)((Object)locationReference.getLocationType()));
            }
        }
        return result;
    }

    public abstract T process(RawLineLocRef var1);

    public abstract T process(RawGeoCoordLocRef var1);

    public abstract T process(RawPointAlongLocRef var1);

    public abstract T process(RawPoiAccessLocRef var1);

    public abstract T process(RawRectangleLocRef var1);

    public abstract T process(RawPolygonLocRef var1);

    public abstract T process(RawCircleLocRef var1);

    public abstract T process(RawGridLocRef var1);

    public abstract T process(RawClosedLineLocRef var1);

    public abstract T processUnknown(RawLocationReference var1);

    private static <T extends RawLocationReference> T castTo(Class<T> locRefClass, RawLocationReference locRef) {
        if (locRefClass.isInstance(locRef)) {
            return (T)((RawLocationReference)locRefClass.cast(locRef));
        }
        throw new IllegalArgumentException("Could not cast " + locRef.getClass() + " to " + locRefClass);
    }
}

